/* DUPLICATOR-PRO (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2020-02-12 12:58:41 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT 0,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT 0,
  `schedule_end` int(10) NOT NULL DEFAULT 0,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `flag_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `flag_popup` tinyint(1) NOT NULL DEFAULT 0,
  `group_id` int(10) DEFAULT NULL,
  `flag_group` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT 0,
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=49711 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=49050 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=13081 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  `advanced` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17748 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  `advanced` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=218 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(10,2) DEFAULT NULL,
  `max_price` decimal(10,2) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("3", "13017", "ActionScheduler", "", "", "", "2019-10-18 00:29:25", "2019-10-18 00:29:25", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "13018", "ActionScheduler", "", "", "", "2019-10-18 00:29:25", "2019-10-18 00:29:25", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "13019", "ActionScheduler", "", "", "", "2019-10-18 00:29:25", "2019-10-18 00:29:25", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "13020", "ActionScheduler", "", "", "", "2019-10-18 00:29:25", "2019-10-18 00:29:25", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "13021", "ActionScheduler", "", "", "", "2019-10-18 00:29:25", "2019-10-18 00:29:25", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "13022", "ActionScheduler", "", "", "", "2019-10-18 00:29:25", "2019-10-18 00:29:25", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "13023", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "13024", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "13025", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "13026", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "13027", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "13028", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "13029", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "13030", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "13031", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "13032", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "13033", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "13034", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "13035", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "13036", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "13037", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "13038", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("25", "13039", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "13040", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("27", "13041", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("28", "13042", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");
INSERT INTO `wp_comments` VALUES("29", "13043", "ActionScheduler", "", "", "", "2019-10-18 00:29:26", "2019-10-18 00:29:26", "action created", "0", "1", "ActionScheduler", "action_log", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_pro_entities */
INSERT INTO `wp_duplicator_pro_entities` VALUES("1", "DUP_PRO_Global_Entity", "{\"uninstall_settings\":false,\"uninstall_files\":false,\"uninstall_tables\":true,\"wpfront_integrate\":false,\"package_ui_created\":1,\"package_mysqldump\":0,\"package_php_chunking\":0,\"package_mysqldump_path\":\"\",\"package_phpdump_qrylimit\":2000,\"archive_build_mode\":2,\"archive_compression\":true,\"ziparchive_validation\":false,\"ziparchive_mode\":0,\"ziparchive_chunk_size_in_mb\":100,\"archive_build_mode_schedule\":2,\"archive_compression_schedule\":true,\"server_load_reduction\":0,\"max_package_runtime_in_min\":90,\"php_max_worker_time_in_sec\":18,\"lock_mode\":0,\"json_mode\":0,\"ajax_protocol\":\"http\",\"custom_ajax_url\":\"http:\\/\\/classic.wpstyle.ir\\/wp-admin\\/admin-ajax.php\",\"clientside_kickoff\":false,\"basic_auth_enabled\":false,\"basic_auth_user\":\"\",\"basic_auth_password\":\"\",\"installer_base_name\":\"installer.php\",\"chunk_size\":2048,\"send_email_on_build_mode\":1,\"notification_email_address\":\"\",\"storage_htaccess_off\":false,\"max_storage_retries\":10,\"max_default_store_files\":20,\"dropbox_upload_chunksize_in_kb\":2000,\"dropbox_transfer_mode\":1,\"gdrive_upload_chunksize_in_kb\":2000,\"s3_upload_part_size_in_kb\":6000,\"manual_mode_storage_ids\":[\"-2\"],\"license_status\":0,\"license_expiration_time\":1571865002,\"license_no_activations_left\":false,\"license_key_visible\":true,\"lkp\":\"\",\"license_limit\":-1,\"last_edd_api_response\":null,\"last_edd_api_timestamp\":0,\"last_system_check_timestamp\":1581428155,\"initial_activation_timestamp\":1571865013,\"debug_on\":false,\"trace_profiler_on\":false,\"profile_idea\":false,\"profile_beta\":false,\"dupHidePackagesGiftFeatures\":false,\"type\":\"DUP_PRO_Global_Entity\",\"notices\":{\"dupArchiveSwitch\":false}}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("2", "DUP_PRO_Secure_Global_Entity", "{\"basic_auth_password\":\"\",\"lkp\":\"\",\"type\":\"DUP_PRO_Secure_Global_Entity\"}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("3", "DUP_PRO_System_Global_Entity", "{\"recommended_fixes\":[],\"schedule_failed\":false,\"package_check_ts\":1581512320,\"type\":\"DUP_PRO_System_Global_Entity\"}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("4", "DUP_PRO_Package_Template_Entity", "{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"installer_opts_cache_wp\":null,\"installer_opts_cache_path\":null,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("5", "DUP_PRO_Package_Template_Entity", "{\"name\":\"[Manual Mode]\",\"notes\":\"The default template.\",\"filter_sites\":\"\",\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":\"\",\"installer_opts_secure_on\":1,\"installer_opts_secure_pass\":\"cHJvc3R5bGU=\",\"installer_opts_skip_scan\":0,\"installer_opts_db_host\":\"\",\"installer_opts_db_name\":\"\",\"installer_opts_db_user\":\"\",\"installer_opts_cpnl_enable\":0,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"installer_opts_cache_wp\":0,\"installer_opts_cache_path\":0,\"is_default\":false,\"is_manual\":true,\"type\":\"DUP_PRO_Package_Template_Entity\"}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("10", "DUP_PRO_DupArchive_Expand_State_Entity", "{\"package_id\":\"7\",\"basePath\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\\/tmp\\/validate\",\"archivePath\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\\/tmp\\/20191128_avadaclassic_c6a407a49db71e146444_20191128183249_archive.daf\",\"isCompressed\":true,\"currentFileOffset\":0,\"archiveOffset\":283863313,\"timeSliceInSecs\":10,\"working\":false,\"startTimestamp\":-1,\"throttleDelayInUs\":0,\"timeoutTimestamp\":1574966169,\"timerEnabled\":true,\"archiveHeaderString\":\"{\\\"version\\\":\\\"3.7.1.1\\\",\\\"isCompressed\\\":true}\",\"currentFileHeaderString\":null,\"failuresString\":\"[]\",\"validateOnly\":true,\"validationType\":1,\"fileWriteCount\":12965,\"directoryWriteCount\":1388,\"expectedFileCount\":12965,\"expectedDirectoryCount\":1388,\"isRobust\":false,\"type\":\"DUP_PRO_DupArchive_Expand_State_Entity\",\"currentFileHeader\":null,\"filteredDirectories\":[],\"filteredFiles\":[],\"includedFiles\":[],\"fileRenames\":[],\"directoryModeOverride\":-1,\"fileModeOverride\":-1,\"lastHeaderOffset\":-1,\"failures\":[]}");

/* INSERT TABLE DATA: wp_duplicator_pro_packages */
INSERT INTO `wp_duplicator_pro_packages` VALUES("9", "20200212_avadaclassicdemo", "fea07b9656a11e5a1831_20200212125821", "20", "2020-02-12 11:58:29", "unknown", "{\"Created\":\"2020-02-12 12:58:21\",\"Version\":\"3.7.1.1\",\"VersionWP\":\"5.2.5\",\"VersionDB\":\"10.2.28\",\"VersionPHP\":\"7.2.24\",\"VersionOS\":\"Linux\",\"ID\":\"9\",\"Name\":\"20200212_avadaclassicdemo\",\"Hash\":\"fea07b9656a11e5a1831_20200212125821\",\"NameHash\":\"20200212_avadaclassicdemo_fea07b9656a11e5a1831_20200212125821\",\"Type\":0,\"Notes\":\"The default template.\",\"StorePath\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20200212_avadaclassicdemo_fea07b9656a11e5a1831_20200212125821_scan.json\",\"timer_start\":1581512321.622457981109619140625,\"Runtime\":null,\"ExeSize\":null,\"ZipSize\":0,\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/ai1wm-backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backupwordpress\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/content\\/cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/contents\\/cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/managewp\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/old-cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/updraft\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/wfcache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/wishlist-backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/.htaccess\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20200212_avadaclassicdemo_fea07b9656a11e5a1831_20200212125821_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\",\"Size\":402755563,\"Dirs\":null,\"RecursiveLinks\":[],\"Files\":null,\"file_count\":-1,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-snapshots\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/ai1wm-backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backupwordpress\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/content\\/cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/contents\\/cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/managewp\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/old-cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/updraft\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/wishlist-backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/wfcache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":8741665,\"bytes\":\"8.34MB\",\"name\":\"shv_paint.webm\",\"dir\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2014\\/05\",\"path\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2014\\/05\\/shv_paint.webm\"},{\"ubytes\":6275740,\"bytes\":\"5.99MB\",\"name\":\"Home-Version-11-Avada.webm\",\"dir\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2014\\/05\",\"path\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2014\\/05\\/Home-Version-11-Avada.webm\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/.htaccess\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]}},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":\"20200212_avadaclassicdemo_fea07b9656a11e5a1831_20200212125821_installer.php\",\"Size\":0,\"OptsSecureOn\":1,\"OptsSecurePass\":\"cHJvc3R5bGU=\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"OptsCacheWP\":0,\"OptsCachePath\":0,\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHP\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8mb4_unicode_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"wpstylei_clasw\",\"tablesBaseCount\":46,\"tablesFinalCount\":46,\"tablesRowCount\":18290,\"tablesSizeOnDisk\":32535088,\"varLowerCaseTables\":\"0\",\"version\":\"10.2.28\",\"versionComment\":\"MariaDB Server\"},\"Type\":\"MySQL\",\"Size\":null,\"File\":\"20200212_avadaclassicdemo_fea07b9656a11e5a1831_20200212125821_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHP\",\"Compatible\":\"\",\"Comments\":\"MariaDB Server\",\"dbStorePathPublic\":null},\"Status\":20,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":1581512321,\"initialized\":true,\"installer_built\":false,\"archive_started\":false,\"archive_has_database\":false,\"archive_built\":false,\"database_script_built\":false,\"failed\":false,\"next_archive_file_index\":0,\"next_archive_dir_index\":0,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":0,\"tableOffset\":0,\"totalRowOffset\":0,\"doneInit\":false,\"doneFiltering\":false,\"doneCreates\":false,\"completed\":false,\"tablesToProcess\":[],\"startTime\":null,\"fileOffset\":0},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":false,\"status_message_details\":\"\",\"started_timestamp\":null,\"stopped_timestamp\":null}],\"active_storage_id\":-1,\"template_id\":5}");
INSERT INTO `wp_duplicator_pro_packages` VALUES("7", "20191128_avadaclassic", "c6a407a49db71e146444_20191128183249", "100", "2019-11-28 17:35:26", "unknown", "{\"Created\":\"2019-11-28 18:32:49\",\"Version\":\"3.7.1.1\",\"VersionWP\":\"5.2.4\",\"VersionDB\":\"10.2.28\",\"VersionPHP\":\"7.2.24\",\"VersionOS\":\"Linux\",\"ID\":\"7\",\"Name\":\"20191128_avadaclassic\",\"Hash\":\"c6a407a49db71e146444_20191128183249\",\"NameHash\":\"20191128_avadaclassic_c6a407a49db71e146444_20191128183249\",\"Type\":0,\"Notes\":\"The default template.\",\"StorePath\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20191128_avadaclassic_c6a407a49db71e146444_20191128183249_scan.json\",\"timer_start\":1574966139.610970973968505859375,\"Runtime\":\"21.862 sec.\",\"ExeSize\":\"42.66KB\",\"ZipSize\":\"270.71MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":1,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/ai1wm-backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backupwordpress\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/content\\/cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/contents\\/cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/managewp\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/old-cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/updraft\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/wfcache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/wishlist-backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/.htaccess\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20191128_avadaclassic_c6a407a49db71e146444_20191128183249_archive.daf\",\"Format\":\"DAF\",\"PackDir\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\",\"Size\":283863313,\"Dirs\":null,\"RecursiveLinks\":[],\"Files\":null,\"file_count\":14353,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-snapshots\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/ai1wm-backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backupwordpress\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/content\\/cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/contents\\/cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/managewp\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/old-cache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/updraft\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/wishlist-backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/wfcache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[{\"ubytes\":8741665,\"bytes\":\"8.34MB\",\"name\":\"shv_paint.webm\",\"dir\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2014\\/05\",\"path\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2014\\/05\\/shv_paint.webm\"},{\"ubytes\":6275740,\"bytes\":\"5.99MB\",\"name\":\"Home-Version-11-Avada.webm\",\"dir\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2014\\/05\",\"path\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2014\\/05\\/Home-Version-11-Avada.webm\"}],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/.htaccess\",\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":[],\"TreeWarning\":[]}},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":\"20191128_avadaclassic_c6a407a49db71e146444_20191128183249_installer.php\",\"Size\":43685,\"OptsSecureOn\":1,\"OptsSecurePass\":\"cHJvc3R5bGU=\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"OptsCacheWP\":0,\"OptsCachePath\":0,\"numFilesAdded\":124,\"numDirsAdded\":17},\"Database\":{\"info\":{\"buildMode\":\"PHP\",\"collationList\":[\"utf8mb4_unicode_520_ci\",\"latin1_swedish_ci\",\"utf8mb4_unicode_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"wpstylei_clasw\",\"tablesBaseCount\":46,\"tablesFinalCount\":46,\"tablesRowCount\":18290,\"tablesSizeOnDisk\":32525512,\"varLowerCaseTables\":\"0\",\"version\":\"10.2.28\",\"versionComment\":\"MariaDB Server\"},\"Type\":\"MySQL\",\"Size\":8651634,\"File\":\"20191128_avadaclassic_c6a407a49db71e146444_20191128183249_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHP\",\"Compatible\":\"\",\"Comments\":\"MariaDB Server\",\"dbStorePathPublic\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\\/tmp\\/20191128_avadaclassic_c6a407a49db71e146444_20191128183249_database.sql\"},\"Status\":100,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":1574966161,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":12841,\"next_archive_dir_index\":1372,\"retries\":0,\"current_build_mode\":3,\"current_build_compression\":true,\"custom_data\":{\"archive_path\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\\/wp-content\\/backups-dup-pro\\/tmp\\/20191128_avadaclassic_c6a407a49db71e146444_20191128183249_archive.daf\",\"time_slice_in_secs\":10,\"base_path\":\"\\/home\\/wpstylei\\/classic.wpstyle.ir\",\"glob_size\":1048576,\"archive_offset\":282763841,\"failures\":[],\"working\":false,\"is_compressed\":true,\"current_file_offset\":0,\"throttle_delay_in_us\":0,\"skipped_directory_count\":1,\"skipped_file_count\":0},\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":0,\"tableOffset\":0,\"totalRowOffset\":0,\"doneInit\":false,\"doneFiltering\":false,\"doneCreates\":false,\"completed\":false,\"tablesToProcess\":[],\"startTime\":null,\"fileOffset\":0},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":true,\"copied_archive\":true,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1574966162,\"stopped_timestamp\":1574966162}],\"active_storage_id\":-2,\"template_id\":4}");

/* INSERT TABLE DATA: wp_layerslider */
INSERT INTO `wp_layerslider` VALUES("1", "1", "Avada Captions Tall", "", "{\"properties\":{\"title\":\"Avada Captions Tall\",\"slug\":\"\",\"sliderVersion\":\"6.5.1\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":615,\"height\":434,\"maxwidth\":\"\",\"responsiveunder\":\"0\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"enabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"twowayslideshow\":true,\"skin\":\"borderlesslight\",\"sliderfadeinduration\":\"350\",\"sliderstyle\":\"margin-bottom: 50px;\",\"backgroundcolor\":\"transparent\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"cover\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"thumb_nav\":\"disabled\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"auto\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"responsive\":true,\"sublayercontainer\":\"0\",\"animatefirstlayer\":true,\"imgpreload\":true,\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\",\"circletimer\":false},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":12375,\"background\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2017\\/07\\/guy_tall_21.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"skip\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2017\\/07\\/guy_tall_21-150x150.jpg\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"Layer #3\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada Theme\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"242px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"31px\\\\\\\"}\",\"style\":\"color: #fff; \\r\\ntext-shadow: none; \\r\\nfont-size: 22px; \\r\\nline-height: 34px; \\r\\npadding: 0px 10px; \\r\\npadding-top: 1px;\\r\\nmargin: 0px; \\r\\nborder-width: 0px; \\r\\nborder-style: none; \\r\\nbackground-color:#000;\\t\\r\\nfont-family: PTSansRegular, Arial, Helvetica, sans-serif;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Amazingly Flexible\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"287px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"31px\\\\\\\"}\",\"style\":\"font-size: 42px; \\r\\nline-height: 45px; \\r\\nfont-family: museoslab500regular;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"We include so many features, shortcodes and options <br> that provides endless combinations for page layouts\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"338px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"32px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false}],\"meta\":{\"activeLayers\":[0],\"undoStackIndex\":2},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/layerslider\\/Avada-Captions-Tall\\/portfolio_2.jpg\",\"backgroundId\":11892,\"backgroundThumb\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/layerslider\\/Avada-Captions-Tall\\/portfolio_2.jpg\"},\"redo\":{\"background\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2017\\/07\\/guy_tall_21.jpg\",\"backgroundId\":12375,\"backgroundThumb\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2017\\/07\\/guy_tall_21.jpg\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"color\":\"#333333\"},\"redo\":{\"color\":\"#ffffff\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"32px\",\"top\":\"364px\"},\"redo\":{\"left\":\"32px\",\"top\":\"338px\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":12376,\"background\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2017\\/07\\/girl_tall_21-600x423.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"skip\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2017\\/07\\/girl_tall_21-600x423-150x150.jpg\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"Layer #3\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada Is\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"240px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"31px\\\\\\\"}\",\"style\":\"color: #fff; \\r\\ntext-shadow: none; \\r\\nfont-size: 22px; \\r\\nline-height: 34px; \\r\\npadding: 0px 10px; \\r\\npadding-top: 1px;\\r\\nmargin: 0px; \\r\\nborder-width: 0px; \\r\\nborder-style: none; \\r\\nbackground-color:#000;\\t\\r\\nfont-family: PTSansRegular, Arial, Helvetica, sans-serif;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Built For You\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"museoslab500regular\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"42px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"284px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"31px\\\\\\\"}\",\"style\":\"\\r\\n\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"We\'ve put so much thought and care into <br> making Avada user friendly for everyone\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"337px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"32px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false}],\"meta\":{\"activeLayers\":[1],\"undoStackIndex\":4},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"background\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/layerslider\\/Avada-Captions-Tall\\/portfolio_1.jpg\",\"backgroundId\":11891,\"backgroundThumb\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/layerslider\\/Avada-Captions-Tall\\/portfolio_1.jpg\"},\"redo\":{\"background\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2017\\/07\\/girl_tall_21-600x423.jpg\",\"backgroundId\":12376,\"backgroundThumb\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/2017\\/07\\/girl_tall_21-600x423.jpg\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"color\":\"#333333\"},\"redo\":{\"color\":\"#ffffff\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"color\":\"#333333\"},\"redo\":{\"color\":\"#ffffff\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"32px\",\"top\":\"364px\"},\"redo\":{\"left\":\"32px\",\"top\":\"337px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"31px\",\"top\":\"286px\"},\"redo\":{\"left\":\"31px\",\"top\":\"284px\"}}]}]}]}", "1497006616", "1500206120", "0", "0", "0", "0", "0", NULL, "0");
INSERT INTO `wp_layerslider` VALUES("2", "1", "Avada Full Width", "", "{\"properties\":{\"title\":\"Avada Full Width\",\"slug\":\"\",\"sliderVersion\":\"6.5.1\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"fullwidth\",\"width\":960,\"height\":400,\"maxwidth\":\"\",\"responsiveunder\":\"960\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":true,\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"twowayslideshow\":true,\"skin\":\"avada\",\"sliderfadeinduration\":\"350\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"#f6f6f6\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"cover\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"forceresponsive\":true,\"animatefirstlayer\":true,\"imgpreload\":true,\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"skip\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"Clouds\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/slide_4.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"0px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"0px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"Mac\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/mac.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"34px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"506px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"iPad\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/ipad2.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"157px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"457px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"iPhone\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/iphone.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"209px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"403px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"Avada Wordpress Theme\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"iransansbold\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"58px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-62px\\\\\\\",\\\\\\\"text-align\\\\\\\":\\\\\\\"right\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"html\":\"\\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631 \\u0637\\u0631\\u0627\\u062d\\u06cc \\u0634\\u062f\\u0647 \\u0628\\u0627 \\u0644\\u0627\\u06cc\\u0631\\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631\"},{\"subtitle\":\"Made With Care...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u06cc\\u06a9\\u06cc \\u0627\\u0632 \\u0642\\u0648\\u06cc\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631\\u0647\\u0627\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"357\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"38\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"38\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"135px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"65px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\",\\\\\\\"text-align\\\\\\\":\\\\\\\"right\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"Lid est laborum ...\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647<br \\/> \\n\\u0648 \\u0645\\u062c\\u0644\\u0647 \\u062f\\u0631 \\u0633\\u062a\\u0648\\u0646 \\u0648 \\u0633\\u0637\\u0631\\u0622\\u0646\\u0686\\u0646\\u0627\\u0646 \\u06a9\\u0647 \\u0644\\u0627\\u0632\\u0645 \\u0627\\u0633\\u062a \\u0648 \\u0628\\u0631\\u0627\\u06cc \\u0634\\u0631\\u0627\\u06cc\\u0637 \\u0641\\u0639\\u0644\\u06cc \\u062a\\u06a9\\u0646\\u0648\\u0644\\u0648\\u0698\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0646\\u06cc\\u0627\\u0632 \\u0648<br \\/> \\n\\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647  \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u0647\\u0627\\u06cc \\u0645\\u062a\\u0646\\u0648\\u0639 \\u0628\\u0627 \\u0647\\u062f\\u0641 \\u0628\\u0647\\u0628\\u0648\\u062f \\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u06cc \\u0645\\u06cc \\u0628\\u0627\\u0634\\u062f.\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"192px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-162px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\",\\\\\\\"text-align\\\\\\\":\\\\\\\"right\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"Purchase Now\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"[fusion_button link=\\\"http:\\/\\/prostyle.ir\\\" color=\\\"default\\\" size=\\\"\\\" type=\\\"\\\" shape=\\\"\\\" target=\\\"_self\\\" title=\\\"\\\" gradient_colors=\\\"|\\\" gradient_hover_colors=\\\"|\\\" accent_color=\\\"\\\" accent_hover_color=\\\"\\\" bevel_color=\\\"\\\" border_width=\\\"1px\\\" shadow=\\\"\\\" icon=\\\"\\\" icon_divider=\\\"yes\\\" icon_position=\\\"left\\\" modal=\\\"\\\" animation_type=\\\"0\\\" animation_direction=\\\"down\\\" animation_speed=\\\"0.1\\\" class=\\\"\\\" id=\\\"\\\"]\\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u0631\\u0627\\u06cc\\u06af\\u0627\\u0646[\\/fusion_button]\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"279px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"1px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false}],\"meta\":{\"activeLayers\":[2],\"undoStackIndex\":14},\"history\":[{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"html\":\"Avada WP Theme\"},\"redo\":{\"html\":\"\\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631 \\u0637\\u0631\\u0627\\u062d\\u06cc \\u0634\\u062f\\u0647 \\u0628\\u0627 \\u0644\\u0627\\u06cc\\u0631\\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"font-family\":\"serif\"},\"redo\":{\"font-family\":\"iransansbold\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"html\":\"Lid est laborum dolo rumes fugats untras. Et harums ser quidem<br \\/> \\nrerum facilisdolores nemis omnis fugiats vitaes nemo minima<br \\/> \\nrerums unsers sadips amets sadips ipsums\"},\"redo\":{\"html\":\"\\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a. \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647<br \\/> \\n\\u0648 \\u0645\\u062c\\u0644\\u0647 \\u062f\\u0631 \\u0633\\u062a\\u0648\\u0646 \\u0648 \\u0633\\u0637\\u0631\\u0622\\u0646\\u0686\\u0646\\u0627\\u0646 \\u06a9\\u0647 \\u0644\\u0627\\u0632\\u0645 \\u0627\\u0633\\u062a \\u0648 \\u0628\\u0631\\u0627\\u06cc \\u0634\\u0631\\u0627\\u06cc\\u0637 \\u0641\\u0639\\u0644\\u06cc \\u062a\\u06a9\\u0646\\u0648\\u0644\\u0648\\u0698\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0646\\u06cc\\u0627\\u0632 \\u0648<br \\/> \\n\\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647  \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u0647\\u0627\\u06cc \\u0645\\u062a\\u0646\\u0648\\u0639 \\u0628\\u0627 \\u0647\\u062f\\u0641 \\u0628\\u0647\\u0628\\u0648\\u062f \\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u06cc \\u0645\\u06cc \\u0628\\u0627\\u0634\\u062f.\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"html\":\"[fusion_button link=\\\"http:\\/\\/themeforest.net\\/item\\/avada-responsive-multipurpose-theme\\/2833226?ref=ThemeFusion\\\" color=\\\"default\\\" size=\\\"\\\" type=\\\"\\\" shape=\\\"\\\" target=\\\"_self\\\" title=\\\"\\\" gradient_colors=\\\"|\\\" gradient_hover_colors=\\\"|\\\" accent_color=\\\"\\\" accent_hover_color=\\\"\\\" bevel_color=\\\"\\\" border_width=\\\"1px\\\" shadow=\\\"\\\" icon=\\\"\\\" icon_divider=\\\"yes\\\" icon_position=\\\"left\\\" modal=\\\"\\\" animation_type=\\\"0\\\" animation_direction=\\\"down\\\" animation_speed=\\\"0.1\\\" class=\\\"\\\" id=\\\"\\\"]Purchase Now![\\/fusion_button]\"},\"redo\":{\"html\":\"[fusion_button link=\\\"http:\\/\\/prostyle.ir\\\" color=\\\"default\\\" size=\\\"\\\" type=\\\"\\\" shape=\\\"\\\" target=\\\"_self\\\" title=\\\"\\\" gradient_colors=\\\"|\\\" gradient_hover_colors=\\\"|\\\" accent_color=\\\"\\\" accent_hover_color=\\\"\\\" bevel_color=\\\"\\\" border_width=\\\"1px\\\" shadow=\\\"\\\" icon=\\\"\\\" icon_divider=\\\"yes\\\" icon_position=\\\"left\\\" modal=\\\"\\\" animation_type=\\\"0\\\" animation_direction=\\\"down\\\" animation_speed=\\\"0.1\\\" class=\\\"\\\" id=\\\"\\\"]\\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u0631\\u0627\\u06cc\\u06af\\u0627\\u0646[\\/fusion_button]\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"html\":\"Made With Care For Our Users\"},\"redo\":{\"html\":\"\\u06cc\\u06a9\\u06cc \\u0627\\u0632 \\u0642\\u0648\\u06cc\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631\\u0647\\u0627\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"text-align\":\"initial\"},\"redo\":{\"text-align\":\"right\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"text-align\":\"initial\"},\"redo\":{\"text-align\":\"right\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"text-align\":\"initial\"},\"redo\":{\"text-align\":\"right\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"1px\",\"top\":\"83px\"},\"redo\":{\"left\":\"-31px\",\"top\":\"88px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"2px\",\"top\":\"195px\"},\"redo\":{\"left\":\"-162px\",\"top\":\"192px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"1px\",\"top\":\"135px\"},\"redo\":{\"left\":\"25px\",\"top\":\"135px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"-31px\",\"top\":\"88px\"},\"redo\":{\"left\":\"-62px\",\"top\":\"58px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"25px\",\"top\":\"135px\"},\"redo\":{\"left\":\"65px\",\"top\":\"135px\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/slide_5.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"skip\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"iPad\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/ipad.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\".2\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\".2\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"54px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-1px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"Avada Is Better ...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0622\\u0648\\u0627\\u062f\\u0627 \\u067e\\u0631\\u0641\\u0631\\u0648\\u0634\\u062a\\u0631\\u06cc\\u0646 \\u0642\\u0627\\u0644\\u0628 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"320\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"67px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"640px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"100% Fully Responsive\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"100% \\u0648\\u0627\\u06a9\\u0646\\u0634\\u06af\\u0631\\u0627\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"250\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"106px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"711px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"With Numerous\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u06a9\\u0627\\u0645\\u0644\\u0627 \\u0628\\u0647\\u06cc\\u0646\\u0647\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"190\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"175px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"770px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"Additions & Optimizations\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0628\\u0633\\u06cc\\u0627\\u0631 \\u067e\\u0631\\u0633\\u0631\\u0639\\u062a\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"285\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"215px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"675px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"It Doesn\\\\\'t Get Better\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0648\\u0627\\u0642\\u0639\\u0627 \\u0633\\u0627\\u062f\\u0647 \\u0648 \\u0642\\u062f\\u0631\\u062a\\u0645\\u0646\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"342\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"289px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"617px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false}],\"meta\":{\"activeLayers\":[4],\"undoStackIndex\":12},\"history\":[{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":4,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":4,\"undo\":{\"html\":\"Avada Is Better Than Ever\"},\"redo\":{\"html\":\"\\u0622\\u0648\\u0627\\u062f\\u0627 \\u0631\\u0627 \\u0628\\u0627\\u0648\\u0631 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u062f\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"html\":\"100% Fully Responsive\"},\"redo\":{\"html\":\"100% \\u0648\\u0627\\u06a9\\u0646\\u0634\\u06af\\u0631\\u0627\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":4,\"undo\":{\"html\":\"\\u0622\\u0648\\u0627\\u062f\\u0627 \\u0631\\u0627 \\u0628\\u0627\\u0648\\u0631 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u062f\"},\"redo\":{\"html\":\"\\u0622\\u0648\\u0627\\u062f\\u0627 \\u067e\\u0631\\u0641\\u0631\\u0648\\u0634\\u062a\\u0631\\u06cc\\u0646 \\u0642\\u0627\\u0644\\u0628 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"html\":\"With Numerous\"},\"redo\":{\"html\":\"\\u06a9\\u0627\\u0645\\u0644\\u0627 \\u0628\\u0647\\u06cc\\u0646\\u0647\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"html\":\"Additions & Optimizations\"},\"redo\":{\"html\":\"\\u0628\\u0633\\u06cc\\u0627\\u0631 \\u067e\\u0631\\u0633\\u0631\\u0639\\u062a\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"html\":\"It Doesn\'t Get Better Than This\"},\"redo\":{\"html\":\"\\u0648\\u0627\\u0642\\u0639\\u0627 \\u0633\\u0627\\u062f\\u0647 \\u0648 \\u0642\\u062f\\u0631\\u062a\\u0645\\u0646\\u062f\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":4,\"undo\":{\"width\":\"295\"},\"redo\":{\"width\":\"320\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"left\":\"666px\",\"top\":\"67px\"},\"redo\":{\"left\":\"640px\",\"top\":\"67px\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/slide_3.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"skip\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"Create Fantastic...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0628\\u0633\\u06cc\\u0627\\u0631 \\u0642\\u062f\\u0631\\u062a\\u0645\\u0646\\u062f \\u0628\\u0627 \\u0627\\u0645\\u06a9\\u0627\\u0646\\u0627\\u062a \\u0641\\u0648\\u0642 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0647\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"430\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"48px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"270px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"Be Creative\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u062e\\u0644\\u0627\\u0642\\u06cc\\u062a \\u0628\\u0627 \\u0622\\u0648\\u0627\\u062f\\u0627\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"150px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"178px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"81px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransansbold\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal; text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"The Possibilities Are...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u067e\\u0631\\u0641\\u0631\\u0648\\u0634\\u062a\\u0631\\u06cc\\u0646 \\u0642\\u0627\\u0644\\u0628 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u062a\\u0627 \\u0628\\u0647 \\u0627\\u0645\\u0631\\u0648\\u0632\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"515\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"315px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"232px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransans\\\\\\\"}\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false}],\"meta\":{\"activeLayers\":[2],\"undoStackIndex\":8},\"history\":[{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"232px\",\"top\":\"275px\"},\"redo\":{\"left\":\"232px\",\"top\":\"295px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"html\":\"The Possibilities Are Endless And Results Stunning\"},\"redo\":{\"html\":\"\\u067e\\u0631\\u0641\\u0631\\u0648\\u0634\\u062a\\u0631\\u06cc\\u0646 \\u0642\\u0627\\u0644\\u0628 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u062a\\u0627 \\u0628\\u0647 \\u0627\\u0645\\u0631\\u0648\\u0632\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"html\":\"Create Fantastic Sliders With Animations\"},\"redo\":{\"html\":\"\\u0628\\u0633\\u06cc\\u0627\\u0631 \\u0642\\u062f\\u0631\\u062a\\u0645\\u0646\\u062f \\u0628\\u0627 \\u0627\\u0645\\u06a9\\u0627\\u0646\\u0627\\u062a \\u0641\\u0648\\u0642 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0647\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"html\":\"BE CREATIVE\"},\"redo\":{\"html\":\"\\u062e\\u0644\\u0627\\u0642\\u06cc\\u062a \\u0628\\u0627 \\u0622\\u0648\\u0627\\u062f\\u0627\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"font-family\":\"\"},\"redo\":{\"font-family\":\"iransans\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"font-family\":\"iransans\"},\"redo\":{\"font-family\":\"iransansbold\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"270px\",\"top\":\"68px\"},\"redo\":{\"left\":\"270px\",\"top\":\"48px\"}}]}]}]}", "1497006616", "1500216127", "0", "0", "0", "0", "0", NULL, "0");
INSERT INTO `wp_layerslider` VALUES("3", "1", "Avada Small Slider", "", "{\"properties\":{\"title\":\"Avada Small Slider\",\"width\":\"451px\",\"height\":\"220px\",\"responsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"borderlesslight3d\",\"backgroundcolor\":\"#f6f6f6\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/iphone.png\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\",\"thumbnailId\":\"\"},\"sublayers\":[{\"subtitle\":\"iPhone\",\"type\":\"img\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/iphone.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"28px\",\"left\":\"73px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":\"\"},{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/logo.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"66px\",\"left\":\"194px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":\"\"},{\"subtitle\":\"Wordpress Theme\",\"type\":\"p\",\"image\":\"\",\"html\":\"Wordpress Theme\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"23px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"114px\",\"left\":\"195px\",\"style\":\"font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/ipad2.png\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\",\"thumbnailId\":\"\"},\"sublayers\":[{\"subtitle\":\"iPad\",\"type\":\"img\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/ipad2.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"33px\",\"left\":\"40px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":\"\"},{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/logo.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"70px\",\"left\":\"235px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":\"\"},{\"subtitle\":\"#1 Selling Theme\",\"type\":\"p\",\"image\":\"\",\"html\":\"#1 Selling Theme\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"23px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"115px\",\"left\":\"234px\",\"style\":\"font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1497006616", "1497006616", "0", "0", "0", "0", "0", NULL, "0");
INSERT INTO `wp_layerslider` VALUES("4", "1", "Avada Transparent Header", "", "{\"properties\":{\"post_type\":[\"attachment\"],\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"Avada Transparent Header\",\"slug\":\"\",\"width\":\"100%\",\"height\":\"650px\",\"maxwidth\":\"\",\"forceresponsive\":\"on\",\"responsiveunder\":\"940\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"loops\":\"0\",\"skin\":\"v5\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"lazyload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"75,79\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/ls_bkgd_color1.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"11000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"5-1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_1.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right -50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"390px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-2\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_2.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left -50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"390px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-3\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_3.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1600\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-4\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_4.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1900\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"right 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-5\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_5.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right 150% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"145px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-6\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_6.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 150% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"145px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"AVADA\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"AVADA\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"340px\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5px\\\\\\\"}\",\"top\":\"132px\",\"left\":\"294px\",\"style\":\"font-weight: 500; text-align: center;  \\r\\nletter-spacing: .1em;\\r\\nfont-family: museoslab500regular; line-height: 115%;\\r\\nopacity: .3;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"POWERFUL OPTIONS\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"POWERFUL OPTIONS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"242px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"for just about anything you need!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"for just about anything you need to help customize!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"288px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"AMAZING SLIDERS\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"AMAZING SLIDERS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"343px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"slide, fade, scale, skew and rotate layers!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"slide, fade, scale, skew and rotate your individual layers!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"391px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"OUTSTANDING SUPPORT\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"OUTSTANDING SUPPORT\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"445px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"trust in us for after sale support!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"trust in us for after sale support, we got your back!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"490px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/html5-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"189px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14 copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/vimeo-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"305px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14 copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/youtube-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"430px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"21,105\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/bg6b.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"8000\",\"timeshift\":\"-1000\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"circle\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/circle.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"115px\",\"left\":\"50%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"circle 2\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/circle.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"115px\",\"left\":\"50%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"&\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"&\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"200px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#f06a52\\\\\\\"}\",\"top\":\"65px\",\"left\":\"2px\",\"style\":\"font-weight: 300; opacity: .4\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"all these features\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"ALL THIS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"29px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"149px\",\"left\":\"0px\",\"style\":\"font-weight: 300; background: white; background: rgba(255,255,255,.85)\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"much more!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"much more!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"-60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"-60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"29px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"199px\",\"left\":\"45px\",\"style\":\"font-weight: 500;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"to create\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"...to create\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"right bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"422px\",\"left\":\"958px\",\"style\":\"font-weight: 500; text-align: right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"the best slider\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"THE BEST SLIDER\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3250\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"260px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#f06a52\\\\\\\"}\",\"top\":\"463px\",\"left\":\"828px\",\"style\":\"font-weight: 300; text-align: right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"with no compromises\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"with no compromises!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Indie Flower\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#d9482b\\\\\\\"}\",\"top\":\"512px\",\"left\":\"829px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"ls5box\",\"media\":\"img\",\"type\":\"p\",\"imageId\":11893,\"image\":\"http:\\/\\/classic.wpstyle.ir\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/ipad.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"147px\",\"left\":\"289px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1497006616", "1497006616", "0", "0", "0", "0", "0", NULL, "0");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://classic.wpstyle.ir", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://classic.wpstyle.ir", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Avada Classic | آوادا کلاسیک", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "دموی کلاسیک قالب پیشرفته آوادا", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "YourEmail@yahoo.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("25170", "woocommerce_tracker_ua", "a:1:{i:0;s:113:\"mozilla/5.0 (windows nt 6.3; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/62.0.3202.94 safari/537.36\";}", "yes");
INSERT INTO `wp_options` VALUES("9445", "theme_mods_ProStyle", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:9:\"404_pages\";i:33;s:15:\"main_navigation\";i:34;s:14:\"top_navigation\";i:36;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1502877595;s:4:\"data\";a:17:{s:19:\"wp_inactive_widgets\";a:17:{i:0;s:18:\"pyre_tabs-widget-4\";i:1;s:21:\"recent_works-widget-4\";i:2;s:21:\"recent_works-widget-5\";i:3;s:21:\"social_links-widget-3\";i:4;s:6:\"text-6\";i:5;s:6:\"text-7\";i:6;s:7:\"text-11\";i:7;s:6:\"text-8\";i:8;s:6:\"text-5\";i:9;s:6:\"text-9\";i:10;s:6:\"text-4\";i:11;s:7:\"text-13\";i:12;s:7:\"text-12\";i:13;s:14:\"recent-posts-5\";i:14;s:12:\"categories-7\";i:15;s:14:\"recent-posts-6\";i:16;s:14:\"recent-posts-3\";}s:18:\"avada-blog-sidebar\";a:7:{i:0;s:8:\"search-2\";i:1;s:18:\"pyre_tabs-widget-7\";i:2;s:14:\"recent-posts-2\";i:3;s:17:\"recent-comments-2\";i:4;s:10:\"archives-2\";i:5;s:12:\"categories-2\";i:6;s:6:\"meta-2\";}s:21:\"avada-footer-widget-1\";a:1:{i:0;s:6:\"text-3\";}s:21:\"avada-footer-widget-2\";a:1:{i:0;s:21:\"recent_works-widget-6\";}s:21:\"avada-footer-widget-3\";a:1:{i:0;s:21:\"contact_info-widget-2\";}s:25:\"avada-slidingbar-widget-1\";a:1:{i:0;s:7:\"text-14\";}s:25:\"avada-slidingbar-widget-2\";a:1:{i:0;s:21:\"recent_works-widget-9\";}s:25:\"avada-slidingbar-widget-3\";a:1:{i:0;s:21:\"contact_info-widget-3\";}s:35:\"avada-custom-sidebar-contactsidebar\";a:2:{i:0;s:21:\"contact_info-widget-4\";i:1;s:21:\"social_links-widget-4\";}s:24:\"avada-custom-sidebar-faq\";a:3:{i:0;s:8:\"search-3\";i:1;s:18:\"pyre_tabs-widget-9\";i:2;s:21:\"recent_works-widget-7\";}s:36:\"avada-custom-sidebar-homepagesidebar\";a:3:{i:0;s:8:\"search-4\";i:1;s:21:\"recent_works-widget-8\";i:2;s:19:\"pyre_tabs-widget-10\";}s:30:\"avada-custom-sidebar-portfolio\";a:1:{i:0;s:18:\"pyre_tabs-widget-8\";}s:30:\"avada-custom-sidebar-megamenu1\";a:0:{}s:30:\"avada-custom-sidebar-megamenu2\";a:0:{}s:28:\"avada-custom-sidebar-twitter\";a:0:{}s:32:\"avada-custom-sidebar-pagewidget1\";a:0:{}s:32:\"avada-custom-sidebar-pagewidget2\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:7:{i:0;s:27:\"LayerSlider/layerslider.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:33:\"fusion-builder/fusion-builder.php\";i:5;s:27:\"fusion-core/fusion-core.php\";i:6;s:23:\"revslider/revslider.php\";i:7;s:23:\"wp-jalali/wp-jalali.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:74:\"/home/wpstylei/classic.wpstyle.ir/wp-content/plugins/duplicator/define.php\";i:2;s:78:\"/home/wpstylei/classic.wpstyle.ir/wp-content/plugins/duplicator/duplicator.php\";i:3;s:72:\"/home/wpstylei/classic.wpstyle.ir/wp-content/plugins/akismet/akismet.php\";i:4;s:92:\"/home/wpstylei/classic.wpstyle.ir/wp-content/plugins/mystickyelements/js/mystickyelements.js\";i:5;s:90:\"/home/wpstylei/classic.wpstyle.ir/wp-content/plugins/mystickyelements/mystickyelements.php\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "Avada", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "Avada", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "44719", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:4:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:12:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:4;a:12:{s:5:\"title\";s:13:\"دسته ها\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:4:{i:3;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:582:\"<img src=\"http://avada.theme-fusion.com/avada-xml/wp-content/uploads/sites/12/2016/04/logo_white_big.png\" alt=\"\" />\r\n<p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد...</p>\";s:6:\"filter\";b:1;}i:14;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:949:\"<img src=\"http://avada.theme-fusion.com/avada-xml/wp-content/uploads/sites/12/2016/04/logo_white_big.png\" alt=\"\" />\r\n\r\nبخش اسلایدینگ بار را میتوانید فعال یا غیر فعال کنید و هر ابزارکی را میتوانید در این قسمت فراخوانی کنید و همچنین می‌توانید در این قسمت از کدهای HTML نیز استفاده کنید.\r\nاسلایدینگ بار دارای 4 ستون هستش که شما میتوانید در 1 ، 2، 3 و یا 4 ستون محتوای خودتون رو قرار بدید. میتوانید رنگ پس زمینه رو تغییر بدید، رنگ جداکننده ستون‌ها و همچنین حالت شیشه‌ای رو فعال کنید، خط بالایی را فعال کنید یا بطوری کلی در موبایل یا PC غیر فعالش کنید. با آوادا هرکاری ممکنه فقط باید بخواهید.\";s:6:\"filter\";s:7:\"content\";}i:15;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:621:\"<img class=\"alignnone size-full wp-image-11474\" src=\"http://classic.wpstyle.ir/wp-content/uploads/2016/04/logo_white_big.png\" alt=\"\" width=\"113\" height=\"25\" />\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد...\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:2:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:39:\"wp-external-links/wp-external-links.php\";a:2:{i:0;s:14:\"WPEL_Uninstall\";i:1;s:13:\"_cb_procedure\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Atlantic/Azores", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "10709", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:12:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:133:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:27:\"access_white_label_branding\";b:1;s:9:\"access_cp\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:109:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:0:{}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:0:{}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("94", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_search", "a:3:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:9:{s:5:\"title\";s:0:\"\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-posts", "a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:3;a:11:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "sidebars_widgets", "a:18:{s:19:\"wp_inactive_widgets\";a:7:{i:0;s:18:\"pyre_tabs-widget-2\";i:1;s:22:\"recent_works-widget-10\";i:2;s:7:\"text-15\";i:3;s:8:\"search-3\";i:4;s:22:\"recent_works-widget-12\";i:5;s:12:\"categories-4\";i:6;s:18:\"pyre_tabs-widget-5\";}s:18:\"avada-blog-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:18:\"pyre_tabs-widget-4\";i:2;s:14:\"recent-posts-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"avada-footer-widget-1\";a:1:{i:0;s:6:\"text-3\";}s:21:\"avada-footer-widget-2\";a:1:{i:0;s:21:\"recent_works-widget-6\";}s:21:\"avada-footer-widget-3\";a:1:{i:0;s:21:\"contact_info-widget-3\";}s:25:\"avada-slidingbar-widget-1\";a:1:{i:0;s:7:\"text-14\";}s:25:\"avada-slidingbar-widget-2\";a:1:{i:0;s:21:\"recent_works-widget-9\";}s:25:\"avada-slidingbar-widget-3\";a:1:{i:0;s:21:\"contact_info-widget-2\";}s:35:\"avada-custom-sidebar-contactsidebar\";a:4:{i:0;s:12:\"categories-3\";i:1;s:18:\"pyre_tabs-widget-3\";i:2;s:14:\"recent-posts-3\";i:3;s:22:\"recent_works-widget-11\";}s:24:\"avada-custom-sidebar-faq\";a:0:{}s:36:\"avada-custom-sidebar-homepagesidebar\";a:0:{}s:30:\"avada-custom-sidebar-portfolio\";a:0:{}s:30:\"avada-custom-sidebar-megamenu1\";a:0:{}s:30:\"avada-custom-sidebar-megamenu2\";a:0:{}s:28:\"avada-custom-sidebar-twitter\";a:1:{i:0;s:28:\"avada-vertical-menu-widget-2\";}s:32:\"avada-custom-sidebar-pagewidget1\";a:0:{}s:32:\"avada-custom-sidebar-pagewidget2\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:7:{i:1581514490;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1581536414;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1581543378;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1581543515;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1581548691;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1581591905;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "theme_mods_twentyseventeen", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:1:{s:3:\"top\";i:34;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1513859767;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:7:\"text-14\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:12:\"categories-3\";i:1;s:14:\"recent-posts-3\";i:2;s:6:\"text-3\";}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("44923", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("18095", "wpsmy_combine_js", "on", "yes");
INSERT INTO `wp_options` VALUES("18096", "wpsmy_combine_css", "on", "yes");
INSERT INTO `wp_options` VALUES("11850", "mysticky_elements_options", "a:3:{s:28:\"myfixed_disable_small_screen\";i:767;s:13:\"myfixed_click\";s:5:\"click\";s:16:\"myfixed_cssstyle\";s:3611:\".mysticky-block-left, .mysticky-block-right { position: fixed; top: 220px; z-index: 999999; } .mysticky-block-icon { cursor: hand; width: 50px; height: 50px; background-position: center; background-repeat: no-repeat; } .mysticky-block-content p { margin: 0; } .mysticky-block-content > div { position: relative; width: 100%; height: 100%; } .mysticky-block-left .mysticky-block-icon { position: absolute; top: 0; right: -50px; } .mysticky-block-right .mysticky-block-icon { position: absolute; top: 0; left: -50px; } .mysticky-block-content hr { margin-bottom: 7px; } .mysticky-block-content img { margin: 5px 0; } .mysticky-block-content a {}/*ProStyle Codes*/ .mysticky-block-left, .mysticky-block-right { height: 100%; } .mysticky-block-content { height: 100%; overflow-x: hidden; overflow-y: scroll; direction: ltr; } .mysticky-block-right .mysticky-block-icon { top: 140px; cursor: pointer; border-radius: 5px 0 0 5px; -webkit-box-shadow: -3px 0px 5px -2px rgba(0,0,0,0.14); -moz-box-shadow: -3px 0px 5px -2px rgba(0,0,0,0.14); box-shadow: -3px 0px 5px -2px rgba(0,0,0,0.14); } .mysticky-block-icon:before { color: #000; content: \"\\f013\"; font-family: fontawesome; font-size: 23px; line-height: 56px; text-align: center; display: block; } .mysticky-block-icon { width: 52px; height: 56px; } .mysticky-block-right .mysticky-block-icon { left: -52px; } span.demo-sites { direction: rtl; } .demo-sites a { float: left; width: 137px; height: 102px; margin-right: 6px; margin-bottom: 6px; position:relative; } .demos-links .persian { position: absolute; display: block; background: rgba(213,78,33,0.95); color: #fff; top: 20px; right: 0; font-size: 13px; font-weight:normal; padding: 0 5px; } .demo-sites a:nth-child(even) { margin-right: 0; } .demo-sites span.demo-bg { background-image:url(http://prostyle.com/wp-content/uploads/avada-demos-pic.jpg); display: inline-block; width: 137px; height: 102px; } .demo-sites span.demo-bg.classic {background-position: -196px 0;} .demo-sites span.demo-bg.construction {background-position: 977px 0;} .demo-sites span.demo-bg.technology {background-position: -2856px 0;} .demo-sites span.demo-bg.creative {background-position: 837px 0;} .demo-sites span.demo-bg.law {background-position: -1316px 0;} .demo-sites span.demo-bg.health {background-position: 1537px 0;} .demo-sites span.demo-bg.fashion {background-position: -756px 0;} .demo-sites span.demo-bg.coming-soon-demo {background-position: 2657px 0;} span.buy-button { display: block; width: 100%; height: 45px; text-align: center; padding: 50px 30px; } span.buy-button:hover { opacity: 0.9; } span.buy-button a { width: 100%; height: 45px; line-height: 45px; font-size: 15px; border: none; color: #fff; background-color: #96c346; text-align:center; margin: 0 0 40px 0; border-radius: 2px; -webkit-border-radius: 2px; } span.training-button { display: inline-block; width: 100%; height: 30px; text-align: center; padding: 0 62px; margin-bottom: 50px; } span.training-button a { width: 100%; height: 35px; line-height: 35px; font-size: 14px; font-weight: normal; color: #8b74ea; text-align:center; margin: 0; border-top: 1px dashed #b9a9fb; border-bottom: 1px dashed #b9a9fb; } span.training-button a:hover { color: #f34ea8; border-top: 1px dashed #fba9d6; border-bottom: 1px dashed #fba9d6; } span.demos-title { display: block; text-align: center; font-weight: bold; font-size: 15px; margin-bottom: 7px; margin-top: 30px; } span.demos-text { display: inline-block; text-align: center; font-weight: normal; font-size: 13px; margin-bottom: 20px; padding: 5px 25px; } span.demos-links { display: block; clear: both; }\";}", "yes");
INSERT INTO `wp_options` VALUES("11851", "mysticky_elements_options9", "a:10:{s:22:\"myfixed_element_enable\";s:6:\"enable\";s:29:\"myfixed_element_side_position\";s:5:\"right\";s:28:\"myfixed_element_top_position\";i:0;s:29:\"myfixed_element_icon_bg_color\";s:7:\"#ffffff\";s:27:\"myfixed_element_icon_bg_img\";s:0:\"\";s:32:\"myfixed_element_content_bg_color\";s:7:\"#ffffff\";s:33:\"myfixed_element_content_txt_color\";s:7:\"#1c1c1c\";s:29:\"myfixed_element_content_width\";i:297;s:31:\"myfixed_element_content_padding\";i:0;s:23:\"myfixed_element_content\";s:2193:\"<span class=\"demo-sites\">\r\n\r\n<span class=\"buy-button\"><a href=\"#\" target=\"_blank\">خرید این قالب</a></span>\r\n\r\n<span class=\"demos-title\">طراحی شده توسط قالب آوادا</span>\r\n\r\n<span class=\"demos-text\">قالب آوادا با امکانات قدرتمند خود به شما این فرصت را می‌دهد تا با هر سلیقه‌ای، هر نوع سایت منحصربفردی را بسازید. طراحی سایت با آوادا بسیار ساده است و فقط باید عناصر صفحه را بکشید و رها کنید. نمونه‌هایی از دموهای ساخته شده با قالب آوادا را مشاهده کنید.</span>\r\n\r\n<span class=\"training-button\"><a href=\"http://prostyle.com/training/\" target=\"_blank\">آموزش‌های رایگان</a></span>\r\n\r\n<span class=\"demos-links\">\r\n<a href=\"http://classic.wpstyle.ir/\" target=\"_blank\"><span class=\"persian\">فارسی</span><span class=\"demo-bg classic\"></span></a>\r\n<a href=\"http://demo.prostyle.com/construction/\" target=\"_blank\"><span class=\"persian\">فارسی</span><span class=\"demo-bg construction\"></span></a>\r\n<a href=\"http://demo.prostyle.com/technology/\" target=\"_blank\"><span class=\"persian\">فارسی</span><span class=\"demo-bg technology\"></span></a>\r\n<a href=\"http://demo.prostyle.com/creative/\" target=\"_blank\"><span class=\"persian\">فارسی</span><span class=\"demo-bg creative\"></span></a>\r\n<a href=\"http://demo.prostyle.com/law/\" target=\"_blank\"><span class=\"persian\">فارسی</span><span class=\"demo-bg law\"></span></a>\r\n<a href=\"http://demo.prostyle.com/health/\" target=\"_blank\"><span class=\"persian\">فارسی</span><span class=\"demo-bg health\"></span></a>\r\n<a href=\"http://demo.prostyle.com/fashion/\" target=\"_blank\"><span class=\"persian\">فارسی</span><span class=\"demo-bg fashion\"></span></a>\r\n<a href=\"#\"><span class=\"demo-bg coming-soon-demo\"></span></a>\r\n<a href=\"#\"><span class=\"demo-bg coming-soon-demo\"></span></a>\r\n<a href=\"#\"><span class=\"demo-bg coming-soon-demo\"></span></a>\r\n<a href=\"#\"><span class=\"demo-bg coming-soon-demo\"></span></a>\r\n<a href=\"#\"><span class=\"demo-bg coming-soon-demo\"></span></a>\r\n</span>\r\n\r\n\r\n\r\n</span>\r\n\";}", "yes");
INSERT INTO `wp_options` VALUES("11852", "mysticky_elements_options8", "a:10:{s:22:\"myfixed_element_enable\";s:7:\"disable\";s:29:\"myfixed_element_side_position\";s:4:\"left\";s:28:\"myfixed_element_top_position\";i:350;s:29:\"myfixed_element_icon_bg_color\";s:7:\"#1bb6ec\";s:27:\"myfixed_element_icon_bg_img\";s:20:\"/img/white/vimeo.png\";s:32:\"myfixed_element_content_bg_color\";s:0:\"\";s:33:\"myfixed_element_content_txt_color\";s:0:\"\";s:29:\"myfixed_element_content_width\";i:500;s:31:\"myfixed_element_content_padding\";i:0;s:23:\"myfixed_element_content\";s:132:\"<iframe src=\"//player.vimeo.com/video/59049515\" width=\"500\" height=\"281\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe>\";}", "yes");
INSERT INTO `wp_options` VALUES("11853", "mysticky_elements_options7", "a:10:{s:22:\"myfixed_element_enable\";s:7:\"disable\";s:29:\"myfixed_element_side_position\";s:4:\"left\";s:28:\"myfixed_element_top_position\";i:410;s:29:\"myfixed_element_icon_bg_color\";s:7:\"#f6400e\";s:27:\"myfixed_element_icon_bg_img\";s:25:\"/img/white/soundcloud.png\";s:32:\"myfixed_element_content_bg_color\";s:0:\"\";s:33:\"myfixed_element_content_txt_color\";s:0:\"\";s:29:\"myfixed_element_content_width\";i:400;s:31:\"myfixed_element_content_padding\";i:0;s:23:\"myfixed_element_content\";s:285:\"<iframe width=\"100%\" height=\"250\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/users/8251512&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\"></iframe>\";}", "yes");
INSERT INTO `wp_options` VALUES("11854", "mysticky_elements_options6", "a:10:{s:22:\"myfixed_element_enable\";s:7:\"disable\";s:29:\"myfixed_element_side_position\";s:4:\"left\";s:28:\"myfixed_element_top_position\";i:470;s:29:\"myfixed_element_icon_bg_color\";s:7:\"#48ad45\";s:27:\"myfixed_element_icon_bg_img\";s:19:\"/img/white/chat.png\";s:32:\"myfixed_element_content_bg_color\";s:7:\"#eaeaea\";s:33:\"myfixed_element_content_txt_color\";s:7:\"#16100e\";s:29:\"myfixed_element_content_width\";i:400;s:31:\"myfixed_element_content_padding\";i:20;s:23:\"myfixed_element_content\";s:131:\"You can add up to 10 elements, position them left or right, change vertical position, change icon img, background color and more...\";}", "yes");
INSERT INTO `wp_options` VALUES("22125", "ppr_version", "5.1.8", "yes");
INSERT INTO `wp_options` VALUES("44891", "rs-templates", "a:3:{s:4:\"hash\";s:32:\"b75789b4e8007da4a017960ffb5efd3c\";s:6:\"slider\";a:442:{i:0;a:22:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:22:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:22:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:22:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:22:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:22:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:413:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:22:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:22:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:22:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:22:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:22:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:22:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:22:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:22:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:22:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:22:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:22:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:22:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:22:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:22:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:22:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:22:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:22:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:22:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:22:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:22:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:22:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:22:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:22:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:22:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:22:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:22:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:22:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:22:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:22:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:22:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:22:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:22:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:22:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:22:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:495:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:22:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:22:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:22:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:22:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:22:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:22:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:22:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:22:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:22:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:22:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:22:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:22:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:22:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:22:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:22:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:22:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:22:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:22:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:22:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:22:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:22:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:22:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:22:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:22:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:22:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:22:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:22:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:25:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:25:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:25:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:25:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:25:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:25:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:25:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:25:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:25:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:25:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:25:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:25:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:25:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:25:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:25:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:25:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:22:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:22:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:22:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:22:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:25:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:25:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:25:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:25:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:25:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:25:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:25:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:25:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:22:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:22:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:25:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:25:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:25:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:25:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:25:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:22:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:22:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:22:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:25:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:25:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:25:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:25:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:22:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:22:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:25:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:25:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:25:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:25:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:25:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:25:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:25:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:25:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:25:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:120;a:25:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:121;a:25:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:25:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:25:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:25:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:25:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:25:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:127;a:25:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:128;a:25:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:129;a:25:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:130;a:25:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:542:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:131;a:22:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:317:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:22:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:22:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:25:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:135;a:22:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:22:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:442:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:22:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:22:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:22:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:387:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:140;a:22:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:22:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:142;a:22:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"{\"1\":{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}}\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:143;a:22:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-carousel-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:22:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/filmstrip-add-on-slider/ \";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:180:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:145;a:22:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/space-opera-presentation/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:22:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/website-intro-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:22:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/minimal-mask-showcase/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:22:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:22:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:150;a:22:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:151;a:25:{s:2:\"id\";s:3:\"154\";s:5:\"title\";s:26:\"GoodNews One-Pager Package\";s:5:\"alias\";s:26:\"goodnews-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"goodnews-one-pager-package\";s:3:\"img\";s:44:\"packages/templatepack_goodnews_one_pager.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:4:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:4:\"hero\";i:3;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:152;a:25:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:153;a:25:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:154;a:25:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:155;a:25:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:156;a:25:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:157;a:25:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:158;a:25:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:159;a:25:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:160;a:25:{s:2:\"id\";s:3:\"163\";s:5:\"title\";s:29:\"GoodNews Content Page Package\";s:5:\"alias\";s:29:\"goodnews-content-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"goodnews-content-page-package\";s:3:\"img\";s:55:\"packages/templatepack_goodnews_content_page_package.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:161;a:25:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:162;a:25:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:163;a:25:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:164;a:25:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:165;a:25:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:166;a:22:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/before-after-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:167;a:22:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:22:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/overexposure-transition-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:22:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/parallax-scroll/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:170;a:25:{s:2:\"id\";s:3:\"173\";s:5:\"title\";s:24:\"TechCo One-Pager Package\";s:5:\"alias\";s:24:\"techco-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:24:\"techco-one-pager-package\";s:3:\"img\";s:28:\"packages/techco_overview.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:171;a:25:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:172;a:25:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:173;a:25:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:174;a:25:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:175;a:25:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:176;a:25:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:177;a:25:{s:2:\"id\";s:3:\"180\";s:5:\"title\";s:19:\"TechCo Testimonials\";s:5:\"alias\";s:19:\"techco-testimonials\";s:3:\"zip\";s:29:\"packs/techco-testimonials.zip\";s:3:\"uid\";s:32:\"3460bd51f6b80599266fecb7fbb918be\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:178;a:25:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:13:\"TechCo Footer\";s:5:\"alias\";s:13:\"techco-footer\";s:3:\"zip\";s:23:\"packs/techco-footer.zip\";s:3:\"uid\";s:32:\"640abcd549137520461a4a71ff758a3b\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:179;a:22:{s:2:\"id\";s:3:\"182\";s:5:\"title\";s:12:\"Live Weather\";s:5:\"alias\";s:7:\"weather\";s:3:\"zip\";s:11:\"weather.zip\";s:3:\"uid\";s:32:\"aab92e69374e4c7b8c6741fe02e574b9\";s:3:\"img\";s:18:\"weather/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-live-weather-add-on/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:168:\"[{\"path\":\"revslider-weather-addon\\/revslider-weather-addon.php\",\"name\":\"Live Weather Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:180;a:22:{s:2:\"id\";s:3:\"183\";s:5:\"title\";s:17:\"360 Panorama Tour\";s:5:\"alias\";s:11:\"360panorama\";s:3:\"zip\";s:15:\"360panorama.zip\";s:3:\"uid\";s:32:\"332720fdacdbb38f65e8327a2a96c52d\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/360-degree-real-estate-virtual-tour/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">An example template for our Panorama 360 tour add-on, created for the real estate market.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:165:\"[{\"path\":\"revslider-panorama-addon\\/revslider-panorama-addon.php\",\"name\":\"Panorama AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:181;a:22:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:14:\"Duotone Add-on\";s:5:\"alias\";s:14:\"duotone-add-on\";s:3:\"zip\";s:18:\"duotone-add-on.zip\";s:3:\"uid\";s:32:\"a428c6f363b3146e96d20a6f44958922\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-duotone-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:168:\"<span class=\"ttm_content\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:350:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-duotonefilters-addon\\/revslider-duotonefilters-addon.php\",\"name\":\"Duotone AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:182;a:22:{s:2:\"id\";s:3:\"185\";s:5:\"title\";s:13:\"Reveal Add-on\";s:5:\"alias\";s:13:\"reveal-add-on\";s:3:\"zip\";s:17:\"reveal-add-on.zip\";s:3:\"uid\";s:32:\"7fa7525d8ff7fa7365cb98a437e88e32\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-content-reveal-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:337:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:201;a:22:{s:2:\"id\";s:3:\"210\";s:5:\"title\";s:21:\"Cryptocurrency Prices\";s:5:\"alias\";s:12:\"cryptoslider\";s:3:\"zip\";s:16:\"cryptoslider.zip\";s:3:\"uid\";s:32:\"c4b02210387f11946223977e940d9e9e\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";s:7:\"preview\";s:95:\"https://revolution.themepunch.com/cryptocurrency-wordpress-price-api-bitcoin-ethereum-litecoin/\";s:7:\"version\";s:5:\"1.0.4\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:209:\"<span class=\"ttm_content\">This Template can show live, animated cryptocurrency prices. More than 1300 currencies are supported, getting prices via the cryptocompare API.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:410:\"<span class=\"ttm_content\">Please refer to the \"Custom JavaScript\" section of this sliders settings, for info on how to modify currencies. Provide a class to the row / column / group where the currency text elements are located in.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:202;a:25:{s:2:\"id\";s:3:\"211\";s:5:\"title\";s:18:\"Immersion One Page\";s:5:\"alias\";s:26:\"immersion-one-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"immersion-one-page-package\";s:3:\"img\";s:31:\"packages/immersion_overview.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:343:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:203;a:25:{s:2:\"id\";s:3:\"212\";s:5:\"title\";s:16:\"Immersion Header\";s:5:\"alias\";s:16:\"immersion_header\";s:3:\"zip\";s:26:\"packs/immersion_header.zip\";s:3:\"uid\";s:32:\"853da51256308b341ecd030bd4883229\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:204;a:25:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:19:\"Immersion Mountains\";s:5:\"alias\";s:19:\"immersion-mountains\";s:3:\"zip\";s:29:\"packs/immersion-mountains.zip\";s:3:\"uid\";s:32:\"817167eb3fe22b7e065ba210cbe6d53c\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:205;a:25:{s:2:\"id\";s:3:\"214\";s:5:\"title\";s:17:\"Immersion Product\";s:5:\"alias\";s:17:\"immersion-product\";s:3:\"zip\";s:27:\"packs/immersion-product.zip\";s:3:\"uid\";s:32:\"64134f263484d2bbcd7ef088ffbbfb4b\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:206;a:25:{s:2:\"id\";s:3:\"215\";s:5:\"title\";s:16:\"Immersion Design\";s:5:\"alias\";s:16:\"immersion-design\";s:3:\"zip\";s:26:\"packs/immersion-design.zip\";s:3:\"uid\";s:32:\"91e1d77c1a2826438763804f4d02bc26\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:207;a:25:{s:2:\"id\";s:3:\"216\";s:5:\"title\";s:22:\"Immersion Phototgraphy\";s:5:\"alias\";s:21:\"immersion-photography\";s:3:\"zip\";s:31:\"packs/immersion-photography.zip\";s:3:\"uid\";s:32:\"e3ddf0c577b09740f5cbf2e38ffd684d\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:208;a:25:{s:2:\"id\";s:3:\"217\";s:5:\"title\";s:14:\"Immersion Grid\";s:5:\"alias\";s:14:\"immersion-grid\";s:3:\"zip\";s:24:\"packs/immersion-grid.zip\";s:3:\"uid\";s:32:\"b6903868189bb83b2c7a852fde3a7dc3\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:209;a:22:{s:2:\"id\";s:3:\"218\";s:5:\"title\";s:18:\"Funky Intro Slider\";s:5:\"alias\";s:11:\"funkyslider\";s:3:\"zip\";s:15:\"funkyslider.zip\";s:3:\"uid\";s:32:\"2d4187e3fdad19b976be335253c8925d\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/funky-intro-slider-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:335:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:210;a:25:{s:2:\"id\";s:3:\"219\";s:5:\"title\";s:19:\"Clear View Magazine\";s:5:\"alias\";s:27:\"clear-view-magazine-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"clear-view-magazine-package\";s:3:\"img\";s:41:\"packages/clear_view_magazine_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:211;a:25:{s:2:\"id\";s:3:\"220\";s:5:\"title\";s:15:\"Clear View Menu\";s:5:\"alias\";s:14:\"clearview_menu\";s:3:\"zip\";s:24:\"packs/clearview_menu.zip\";s:3:\"uid\";s:32:\"eaecee5fa5f3c3a7f4d2a96c4616a353\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:212;a:25:{s:2:\"id\";s:3:\"221\";s:5:\"title\";s:17:\"Clear View Header\";s:5:\"alias\";s:16:\"clearview_header\";s:3:\"zip\";s:26:\"packs/clearview_header.zip\";s:3:\"uid\";s:32:\"25e3dd80ad130875d7438a07952cb0cd\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:213;a:25:{s:2:\"id\";s:3:\"222\";s:5:\"title\";s:18:\"Clear View Mission\";s:5:\"alias\";s:17:\"clearview_mission\";s:3:\"zip\";s:27:\"packs/clearview_mission.zip\";s:3:\"uid\";s:32:\"35b2092a49fd2beb549342e69097eb5b\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:214;a:25:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:17:\"Clear View Slider\";s:5:\"alias\";s:17:\"clear-view-slider\";s:3:\"zip\";s:27:\"packs/clear-view-slider.zip\";s:3:\"uid\";s:32:\"d2e17edffce16ed78c54b0ef23fd7e05\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:215;a:25:{s:2:\"id\";s:3:\"224\";s:5:\"title\";s:15:\"Clear View News\";s:5:\"alias\";s:15:\"clear-view-news\";s:3:\"zip\";s:25:\"packs/clear-view-news.zip\";s:3:\"uid\";s:32:\"5698d3131ba141e9afcfd2906739dd00\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:216;a:25:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:18:\"Clear View Clients\";s:5:\"alias\";s:18:\"clear-view-clients\";s:3:\"zip\";s:28:\"packs/clear-view-clients.zip\";s:3:\"uid\";s:32:\"b95616a94832e22bdfac5ce60232be1b\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:217;a:25:{s:2:\"id\";s:3:\"226\";s:5:\"title\";s:18:\"Clear View Contact\";s:5:\"alias\";s:18:\"clear-view-contact\";s:3:\"zip\";s:28:\"packs/clear-view-contact.zip\";s:3:\"uid\";s:32:\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:218;a:25:{s:2:\"id\";s:3:\"227\";s:5:\"title\";s:20:\"Clear View Post Page\";s:5:\"alias\";s:28:\"clear-view-post-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"clear-view-post-page-package\";s:3:\"img\";s:42:\"packages/clear_view_post_page_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:219;a:25:{s:2:\"id\";s:3:\"228\";s:5:\"title\";s:22:\"Clear View Single Menu\";s:5:\"alias\";s:22:\"clear-view-single-menu\";s:3:\"zip\";s:32:\"packs/clear-view-single-menu.zip\";s:3:\"uid\";s:32:\"1e80f81982f8a4ea763482d4fa99d321\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:220;a:25:{s:2:\"id\";s:3:\"229\";s:5:\"title\";s:24:\"Clear View Single Header\";s:5:\"alias\";s:24:\"clear-view-single-header\";s:3:\"zip\";s:34:\"packs/clear-view-single-header.zip\";s:3:\"uid\";s:32:\"c8d717627be6cd5e70922ab609694dbf\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:221;a:25:{s:2:\"id\";s:3:\"230\";s:5:\"title\";s:23:\"Clear View Single Media\";s:5:\"alias\";s:23:\"clear-view-single-media\";s:3:\"zip\";s:33:\"packs/clear-view-single-media.zip\";s:3:\"uid\";s:32:\"c480368ded2a64f0cdd44f1674213814\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:222;a:25:{s:2:\"id\";s:3:\"231\";s:5:\"title\";s:22:\"Clear View Single More\";s:5:\"alias\";s:22:\"clear-view-single-more\";s:3:\"zip\";s:32:\"packs/clear-view-single-more.zip\";s:3:\"uid\";s:32:\"9c693190df26218366d1f77e10cf550a\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:223;a:25:{s:2:\"id\";s:3:\"232\";s:5:\"title\";s:25:\"Clear View Single Contact\";s:5:\"alias\";s:25:\"clear-view-single-contact\";s:3:\"zip\";s:35:\"packs/clear-view-single-contact.zip\";s:3:\"uid\";s:32:\"73c0a889f2b654a87b5aba1ff76fbc5c\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:224;a:22:{s:2:\"id\";s:3:\"233\";s:5:\"title\";s:18:\"Clean Landing Page\";s:5:\"alias\";s:16:\"cleanlandingpage\";s:3:\"zip\";s:20:\"cleanlandingpage.zip\";s:3:\"uid\";s:32:\"727a3680d312f22c6a5998ebdb9afe52\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/clean-landing-page-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:203:\"<span class=\"ttm_content\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:225;a:22:{s:2:\"id\";s:3:\"234\";s:5:\"title\";s:9:\"Clear Cut\";s:5:\"alias\";s:8:\"clearcut\";s:3:\"zip\";s:12:\"clearcut.zip\";s:3:\"uid\";s:32:\"07f43c00e9b4d3057a03cdb3385ad2b7\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/clear-cut-portfolio-website-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:240:\"<span class=\"ttm_content\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:226;a:25:{s:2:\"id\";s:3:\"235\";s:5:\"title\";s:22:\"Wonderstruck One-Pager\";s:5:\"alias\";s:30:\"wonderstruck-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:30:\"wonderstruck-one-pager-package\";s:3:\"img\";s:44:\"packages/wonderstruck-one-pager-overview.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:227;a:25:{s:2:\"id\";s:3:\"236\";s:5:\"title\";s:17:\"Wonderstruck Menu\";s:5:\"alias\";s:17:\"wonderstruck_menu\";s:3:\"zip\";s:27:\"packs/wonderstruck_menu.zip\";s:3:\"uid\";s:32:\"0a976e9aaae59c4f795b38f59f5a08d8\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:228;a:25:{s:2:\"id\";s:3:\"237\";s:5:\"title\";s:19:\"Wonderstruck Header\";s:5:\"alias\";s:19:\"wonderstruck_header\";s:3:\"zip\";s:29:\"packs/wonderstruck_header.zip\";s:3:\"uid\";s:32:\"e1379f77a902960a0ce12d44d85a9e0a\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:229;a:25:{s:2:\"id\";s:3:\"238\";s:5:\"title\";s:18:\"Wonderstruck About\";s:5:\"alias\";s:18:\"wonderstruck_about\";s:3:\"zip\";s:28:\"packs/wonderstruck_about.zip\";s:3:\"uid\";s:32:\"d207fb140fd328acc3038300ea52082a\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:230;a:25:{s:2:\"id\";s:3:\"239\";s:5:\"title\";s:18:\"Wonderstruck Works\";s:5:\"alias\";s:18:\"wonderstruck-works\";s:3:\"zip\";s:28:\"packs/wonderstruck-works.zip\";s:3:\"uid\";s:32:\"4476935097e27d92454b0011b7700c1d\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:231;a:25:{s:2:\"id\";s:3:\"240\";s:5:\"title\";s:20:\"Wonderstruck Contact\";s:5:\"alias\";s:20:\"wonderstruck-contact\";s:3:\"zip\";s:30:\"packs/wonderstruck-contact.zip\";s:3:\"uid\";s:32:\"9e4911521f77bce2b8efa40f4c2adc22\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:232;a:22:{s:2:\"id\";s:3:\"241\";s:5:\"title\";s:12:\"Bubble Morph\";s:5:\"alias\";s:11:\"bubblemorph\";s:3:\"zip\";s:15:\"bubblemorph.zip\";s:3:\"uid\";s:32:\"1102d6f5460ab82cb612cbe9f1d9514b\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/bubble-morph-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:188:\"<span class=\"ttm_content\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:233;a:22:{s:2:\"id\";s:3:\"242\";s:5:\"title\";s:16:\"Distortion AddOn\";s:5:\"alias\";s:15:\"distortionaddon\";s:3:\"zip\";s:19:\"distortionaddon.zip\";s:3:\"uid\";s:32:\"0ad46c9929bb2fa6316f1e6ced301aaf\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/distortion-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:234;a:22:{s:2:\"id\";s:3:\"243\";s:5:\"title\";s:10:\"Club Flyer\";s:5:\"alias\";s:9:\"clubflyer\";s:3:\"zip\";s:13:\"clubflyer.zip\";s:3:\"uid\";s:32:\"dab73b9904d0e643a35b0475980998bd\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/club-flyer-landing-page-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:187:\"[{\"path\":\"revslider-explodinglayers-addon\\/revslider-explodinglayers-addon.php\",\"name\":\"Exploding Layers AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:235;a:22:{s:2:\"id\";s:3:\"244\";s:5:\"title\";s:16:\"Paintbrush AddOn\";s:5:\"alias\";s:15:\"paintbrushaddon\";s:3:\"zip\";s:19:\"paintbrushaddon.zip\";s:3:\"uid\";s:32:\"c85c48a6742b4bf72a2590cc1b50f6a0\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/paintbrush-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-paintbrush-addon\\/revslider-paintbrush-addon.php\",\"name\":\"Paintbrush AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:236;a:25:{s:2:\"id\";s:3:\"245\";s:5:\"title\";s:18:\"Parallax One-Pager\";s:5:\"alias\";s:26:\"parallax-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"parallax-one-pager-package\";s:3:\"img\";s:39:\"packages/parallax-one-pager-package.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:237;a:25:{s:2:\"id\";s:3:\"246\";s:5:\"title\";s:15:\"Parallax Header\";s:5:\"alias\";s:15:\"parallax_header\";s:3:\"zip\";s:25:\"packs/parallax_header.zip\";s:3:\"uid\";s:32:\"32bf4a0f5136853bd6bd366275a7a60b\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:238;a:25:{s:2:\"id\";s:3:\"247\";s:5:\"title\";s:16:\"Parallax Content\";s:5:\"alias\";s:16:\"parallax_content\";s:3:\"zip\";s:26:\"packs/parallax_content.zip\";s:3:\"uid\";s:32:\"a25c5fb8f74757476ab4dc038e56f90d\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:239;a:25:{s:2:\"id\";s:3:\"248\";s:5:\"title\";s:15:\"Parallax Footer\";s:5:\"alias\";s:15:\"parallax_footer\";s:3:\"zip\";s:25:\"packs/parallax_footer.zip\";s:3:\"uid\";s:32:\"665dff9ea6eaf162a2a1f160f51a9ddb\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:240;a:25:{s:2:\"id\";s:3:\"249\";s:5:\"title\";s:18:\"Le Chef Restaurant\";s:5:\"alias\";s:18:\"le-chef-restaurant\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"le-chef-restaurant-package\";s:3:\"img\";s:39:\"packages/le-chef-restaurant-package.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:241;a:25:{s:2:\"id\";s:3:\"250\";s:5:\"title\";s:12:\"Le Chef Menu\";s:5:\"alias\";s:12:\"le-chef-menu\";s:3:\"zip\";s:22:\"packs/le-chef-menu.zip\";s:3:\"uid\";s:32:\"2f2a6a333431fefe4a7b3b6a982b2ff5\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:242;a:25:{s:2:\"id\";s:3:\"251\";s:5:\"title\";s:14:\"Le Chef Header\";s:5:\"alias\";s:14:\"le-chef-header\";s:3:\"zip\";s:24:\"packs/le-chef-header.zip\";s:3:\"uid\";s:32:\"06450ca3be5a4a8959f3752ab974e574\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:243;a:25:{s:2:\"id\";s:3:\"252\";s:5:\"title\";s:18:\"Le Chef Philosophy\";s:5:\"alias\";s:18:\"le-chef-philosophy\";s:3:\"zip\";s:28:\"packs/le-chef-philosophy.zip\";s:3:\"uid\";s:32:\"a532fd029addeb18106e751409b8e20a\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:244;a:25:{s:2:\"id\";s:3:\"253\";s:5:\"title\";s:12:\"Le Chef Food\";s:5:\"alias\";s:12:\"le-chef-food\";s:3:\"zip\";s:22:\"packs/le-chef-food.zip\";s:3:\"uid\";s:32:\"cd4b6a2cb5de2dd20a0e8ba0c35451df\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:245;a:25:{s:2:\"id\";s:3:\"254\";s:5:\"title\";s:16:\"Le Chef La Carte\";s:5:\"alias\";s:16:\"le-chef-la-carte\";s:3:\"zip\";s:26:\"packs/le-chef-la-carte.zip\";s:3:\"uid\";s:32:\"6f312749679c3ba52c41189a6b8bf729\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:246;a:25:{s:2:\"id\";s:3:\"255\";s:5:\"title\";s:14:\"Le Chef Footer\";s:5:\"alias\";s:14:\"le-chef-footer\";s:3:\"zip\";s:24:\"packs/le-chef-footer.zip\";s:3:\"uid\";s:32:\"12fc241e8e5b9e5df9758c43448e2907\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:247;a:22:{s:2:\"id\";s:3:\"256\";s:5:\"title\";s:20:\"News Magazine Slider\";s:5:\"alias\";s:20:\"news-magazine-slider\";s:3:\"zip\";s:24:\"news-magazine-slider.zip\";s:3:\"uid\";s:32:\"31f2c1506babb1fef459401f051d2d52\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/news-magazine-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">The Magazine Slider offers various layouts that support static content images, HTML5 and Youtube video. Great for any blog or news website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:248;a:22:{s:2:\"id\";s:3:\"257\";s:5:\"title\";s:18:\"Real Estate Slider\";s:5:\"alias\";s:18:\"real-estate-slider\";s:3:\"zip\";s:22:\"real-estate-slider.zip\";s:3:\"uid\";s:32:\"739ce6336e46815094387c9448e6c804\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/real-estate-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">The Real Estate Slider allows to display real estate offers with a large ken burns background image and additional thumbnail hover images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:249;a:22:{s:2:\"id\";s:3:\"258\";s:5:\"title\";s:14:\"Fashion Header\";s:5:\"alias\";s:14:\"fashion-header\";s:3:\"zip\";s:18:\"fashion-header.zip\";s:3:\"uid\";s:32:\"24ece4e7f4d31cd90377c62abbd9e25a\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/fashion-shop-header-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:254:\"<span class=\"ttm_content\">The Fashion Shop Header ist the ideal Slider to display as an intro to your shop website or as a separator in between content. Our unique \"Bubble Morph\" effect makes this module stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:250;a:22:{s:2:\"id\";s:3:\"259\";s:5:\"title\";s:14:\"Seasonal Offer\";s:5:\"alias\";s:13:\"seasonaloffer\";s:3:\"zip\";s:17:\"seasonaloffer.zip\";s:3:\"uid\";s:32:\"caf2f17f8fd64f2f89dcb3c8dd238457\";s:3:\"img\";s:24:\"seasonaloffer/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/seasonal-offer-christmas-header-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">Use the Seasonal Offer Header to promote special offers in the holiday season, or just to add some snowy christmas spirit to your website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:251;a:25:{s:2:\"id\";s:3:\"260\";s:5:\"title\";s:11:\"Barber Shop\";s:5:\"alias\";s:11:\"barber-shop\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:19:\"barber-shop-package\";s:3:\"img\";s:32:\"packages/barber-shop-package.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:252;a:25:{s:2:\"id\";s:3:\"261\";s:5:\"title\";s:18:\"Barber Shop Header\";s:5:\"alias\";s:18:\"barber-shop-header\";s:3:\"zip\";s:28:\"packs/barber-shop-header.zip\";s:3:\"uid\";s:32:\"71c995d36d39a0e8a04cffdf753f2ba2\";s:3:\"img\";s:29:\"barber-shop-header/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:253;a:25:{s:2:\"id\";s:3:\"262\";s:5:\"title\";s:23:\"Barber Shop Mobile Menu\";s:5:\"alias\";s:23:\"barber-shop-mobile-menu\";s:3:\"zip\";s:33:\"packs/barber-shop-mobile-menu.zip\";s:3:\"uid\";s:32:\"762c6fb5c6306f37becb1e55773c2592\";s:3:\"img\";s:34:\"barber-shop-mobile-menu/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:254;a:25:{s:2:\"id\";s:3:\"263\";s:5:\"title\";s:24:\"Barber Shop First Screen\";s:5:\"alias\";s:24:\"barber-shop-first-screen\";s:3:\"zip\";s:34:\"packs/barber-shop-first-screen.zip\";s:3:\"uid\";s:32:\"acf70bfd64cff2c3c2ea5585223575da\";s:3:\"img\";s:35:\"barber-shop-first-screen/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:255;a:25:{s:2:\"id\";s:3:\"264\";s:5:\"title\";s:17:\"Barber Shop About\";s:5:\"alias\";s:17:\"barber-shop-about\";s:3:\"zip\";s:27:\"packs/barber-shop-about.zip\";s:3:\"uid\";s:32:\"bc8b63cfc7f8c34173b4fd5b082fc05a\";s:3:\"img\";s:28:\"barber-shop-about/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:256;a:25:{s:2:\"id\";s:3:\"265\";s:5:\"title\";s:20:\"Barber Shop Services\";s:5:\"alias\";s:20:\"barber-shop-services\";s:3:\"zip\";s:30:\"packs/barber-shop-services.zip\";s:3:\"uid\";s:32:\"d65121d6f84fabd812a2b621b768e10e\";s:3:\"img\";s:31:\"barber-shop-services/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:257;a:25:{s:2:\"id\";s:3:\"266\";s:5:\"title\";s:19:\"Barber Shop Barbers\";s:5:\"alias\";s:19:\"barber-shop-barbers\";s:3:\"zip\";s:29:\"packs/barber-shop-barbers.zip\";s:3:\"uid\";s:32:\"003e9fec9693072119c8f8d8b6690c4d\";s:3:\"img\";s:30:\"barber-shop-barbers/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:258;a:25:{s:2:\"id\";s:3:\"267\";s:5:\"title\";s:20:\"Barber Shop Contacts\";s:5:\"alias\";s:20:\"barber-shop-contacts\";s:3:\"zip\";s:30:\"packs/barber-shop-contacts.zip\";s:3:\"uid\";s:32:\"cdcc08f5d6c90dbcfd0502bda2401643\";s:3:\"img\";s:31:\"barber-shop-contacts/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:259;a:25:{s:2:\"id\";s:3:\"268\";s:5:\"title\";s:18:\"Barber Shop Footer\";s:5:\"alias\";s:18:\"barber-shop-footer\";s:3:\"zip\";s:28:\"packs/barber-shop-footer.zip\";s:3:\"uid\";s:32:\"26ca5ae0de7cdbb2ca19348b6e01eda0\";s:3:\"img\";s:29:\"barber-shop-footer/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:260;a:22:{s:2:\"id\";s:3:\"269\";s:5:\"title\";s:12:\"Fitness Club\";s:5:\"alias\";s:21:\"fitness-club-template\";s:3:\"zip\";s:25:\"fitness-club-template.zip\";s:3:\"uid\";s:32:\"14ea10d68d6aad1df62b3becf71df754\";s:3:\"img\";s:32:\"fitness-club-template/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/fitness-club-header-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:223:\"<span class=\"ttm_content\">The Fitness Club Header is the perfect introduction to your fitness themed website. Showcase your current offers or service portfolio with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:261;a:22:{s:2:\"id\";s:3:\"270\";s:5:\"title\";s:13:\"Soccer School\";s:5:\"alias\";s:13:\"soccer-school\";s:3:\"zip\";s:17:\"soccer-school.zip\";s:3:\"uid\";s:32:\"9906b48812aff67097f990eeee42dd41\";s:3:\"img\";s:24:\"soccer-school/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/soccer-club-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:228:\"<span class=\"ttm_content\">The Soccer Club Header is the perfect introduction to your Soccer School themed website. Showcase your current offers or service portfolio with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:262;a:22:{s:2:\"id\";s:3:\"271\";s:5:\"title\";s:10:\"Music Band\";s:5:\"alias\";s:19:\"music-band-template\";s:3:\"zip\";s:23:\"music-band-template.zip\";s:3:\"uid\";s:32:\"91e79657bf1b1812f8114a00ab8e0eb4\";s:3:\"img\";s:30:\"music-band-template/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/music-band-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Music Band Header is the perfect introduction to your Music Band themed website. Showcase your current songs, albums and videos with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:263;a:22:{s:2:\"id\";s:3:\"272\";s:5:\"title\";s:15:\"Restaurant Menu\";s:5:\"alias\";s:15:\"restaurant-menu\";s:3:\"zip\";s:19:\"restaurant-menu.zip\";s:3:\"uid\";s:32:\"078809cffb21b6c4d3f5aaa2daeb193d\";s:3:\"img\";s:26:\"restaurant-menu/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/restaurant-menu-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:208:\"<span class=\"ttm_content\">The Restaurant Menu Header is the perfect introduction to your Restaurant themed website. Showcase your current dishes with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:264;a:22:{s:2:\"id\";s:3:\"273\";s:5:\"title\";s:16:\"Cinematic Slider\";s:5:\"alias\";s:16:\"cinematic-slider\";s:3:\"zip\";s:20:\"cinematic-slider.zip\";s:3:\"uid\";s:32:\"c53e7dcbb6b656ae7b4c91d333589838\";s:3:\"img\";s:27:\"cinematic-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/cinematic-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:138:\"<span class=\"ttm_content\">Bold texts and a cinematic transition effect make this slider stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:265;a:22:{s:2:\"id\";s:3:\"274\";s:5:\"title\";s:17:\"3D Parallax Cubes\";s:5:\"alias\";s:17:\"3d-parallax-cubes\";s:3:\"zip\";s:21:\"3d-parallax-cubes.zip\";s:3:\"uid\";s:32:\"c5b809a1829f8f809c9a768cd3d6b3cb\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/3d-parallax-cubes-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">This amazing 3D cubes parallax effect can be an eye-opening intro for your website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:266;a:25:{s:2:\"id\";s:3:\"275\";s:5:\"title\";s:33:\"Medicare Medical Services Website\";s:5:\"alias\";s:33:\"medicare-medical-services-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:41:\"medicare-medical-services-website-package\";s:3:\"img\";s:29:\"packages/medicare_package.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:267;a:25:{s:2:\"id\";s:3:\"276\";s:5:\"title\";s:13:\"Medicare Menu\";s:5:\"alias\";s:13:\"medicare-menu\";s:3:\"zip\";s:23:\"packs/medicare-menu.zip\";s:3:\"uid\";s:32:\"0e4ca8fc281e20251b3fffa19d470fed\";s:3:\"img\";s:24:\"medicare-menu/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:268;a:25:{s:2:\"id\";s:3:\"277\";s:5:\"title\";s:15:\"Medicare Header\";s:5:\"alias\";s:15:\"medicare-header\";s:3:\"zip\";s:25:\"packs/medicare-header.zip\";s:3:\"uid\";s:32:\"03e8ade247d8c96f548bc0515f34043f\";s:3:\"img\";s:26:\"medicare-header/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:269;a:25:{s:2:\"id\";s:3:\"278\";s:5:\"title\";s:14:\"Medicare About\";s:5:\"alias\";s:14:\"medicare-about\";s:3:\"zip\";s:24:\"packs/medicare-about.zip\";s:3:\"uid\";s:32:\"a3ab9e89155ef2542820343f30b29f72\";s:3:\"img\";s:25:\"medicare-about/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:270;a:25:{s:2:\"id\";s:3:\"279\";s:5:\"title\";s:18:\"Medicare Highlight\";s:5:\"alias\";s:18:\"medicare-highlight\";s:3:\"zip\";s:28:\"packs/medicare-highlight.zip\";s:3:\"uid\";s:32:\"c3c8a74e5402489f1a85a0c83890ef1f\";s:3:\"img\";s:29:\"medicare-highlight/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:271;a:25:{s:2:\"id\";s:3:\"280\";s:5:\"title\";s:17:\"Medicare Services\";s:5:\"alias\";s:17:\"medicare-services\";s:3:\"zip\";s:27:\"packs/medicare-services.zip\";s:3:\"uid\";s:32:\"8869b0834d4649dcc3221bed65980806\";s:3:\"img\";s:28:\"medicare-services/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:272;a:25:{s:2:\"id\";s:3:\"281\";s:5:\"title\";s:16:\"Medicare Doctors\";s:5:\"alias\";s:16:\"medicare-doctors\";s:3:\"zip\";s:26:\"packs/medicare-doctors.zip\";s:3:\"uid\";s:32:\"2c9d57afd64244b5f7e30b0d87c842f9\";s:3:\"img\";s:27:\"medicare-doctors/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:273;a:25:{s:2:\"id\";s:3:\"282\";s:5:\"title\";s:17:\"Medicare Research\";s:5:\"alias\";s:17:\"medicare-research\";s:3:\"zip\";s:27:\"packs/medicare-research.zip\";s:3:\"uid\";s:32:\"31e84a91fc8b8d5296e715e539a076d0\";s:3:\"img\";s:28:\"medicare-research/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:274;a:25:{s:2:\"id\";s:3:\"283\";s:5:\"title\";s:19:\"Medicare Why Choose\";s:5:\"alias\";s:18:\"medicare-whychoose\";s:3:\"zip\";s:28:\"packs/medicare-whychoose.zip\";s:3:\"uid\";s:32:\"6dad61c672127de9e35884caa45d49a0\";s:3:\"img\";s:29:\"medicare-whychoose/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:275;a:25:{s:2:\"id\";s:3:\"284\";s:5:\"title\";s:16:\"Medicare Contact\";s:5:\"alias\";s:16:\"medicare-contact\";s:3:\"zip\";s:26:\"packs/medicare-contact.zip\";s:3:\"uid\";s:32:\"89bc35ad8beb62a149c42262ae49a270\";s:3:\"img\";s:27:\"medicare-contact/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:276;a:25:{s:2:\"id\";s:3:\"285\";s:5:\"title\";s:15:\"Medicare Footer\";s:5:\"alias\";s:15:\"medicare-footer\";s:3:\"zip\";s:25:\"packs/medicare-footer.zip\";s:3:\"uid\";s:32:\"ccf63e5233b3d63009e5ee90db51b37b\";s:3:\"img\";s:26:\"medicare-footer/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:277;a:25:{s:2:\"id\";s:3:\"286\";s:5:\"title\";s:20:\"Coffee Joint Website\";s:5:\"alias\";s:20:\"coffee-joint-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"coffee-joint-website-package\";s:3:\"img\";s:27:\"packages/coffee_package.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:278;a:25:{s:2:\"id\";s:3:\"287\";s:5:\"title\";s:11:\"Coffee Menu\";s:5:\"alias\";s:11:\"coffee-menu\";s:3:\"zip\";s:21:\"packs/coffee-menu.zip\";s:3:\"uid\";s:32:\"81195cad7be3f5180a267b34ce8cf966\";s:3:\"img\";s:22:\"coffee-menu/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:279;a:25:{s:2:\"id\";s:3:\"288\";s:5:\"title\";s:13:\"Coffee Header\";s:5:\"alias\";s:13:\"coffee-header\";s:3:\"zip\";s:23:\"packs/coffee-header.zip\";s:3:\"uid\";s:32:\"5eed8adb9d3ae12168ad4735ac63eb20\";s:3:\"img\";s:24:\"coffee-header/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:280;a:25:{s:2:\"id\";s:3:\"289\";s:5:\"title\";s:17:\"Coffee Philosophy\";s:5:\"alias\";s:17:\"coffee-philosophy\";s:3:\"zip\";s:27:\"packs/coffee-philosophy.zip\";s:3:\"uid\";s:32:\"76b5ccae3fa87fd0f991b87e7ae71c27\";s:3:\"img\";s:28:\"coffee-philosophy/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:281;a:25:{s:2:\"id\";s:3:\"290\";s:5:\"title\";s:12:\"Coffee Carte\";s:5:\"alias\";s:12:\"coffee-carte\";s:3:\"zip\";s:22:\"packs/coffee-carte.zip\";s:3:\"uid\";s:32:\"470214ddd2cec585629fb79a0fd908d6\";s:3:\"img\";s:23:\"coffee-carte/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:282;a:25:{s:2:\"id\";s:3:\"291\";s:5:\"title\";s:13:\"Coffee Teaser\";s:5:\"alias\";s:13:\"coffee-teaser\";s:3:\"zip\";s:23:\"packs/coffee-teaser.zip\";s:3:\"uid\";s:32:\"2ed868896c92a7bfb6431803c79e8486\";s:3:\"img\";s:24:\"coffee-teaser/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:283;a:25:{s:2:\"id\";s:3:\"292\";s:5:\"title\";s:14:\"Coffee Find Us\";s:5:\"alias\";s:13:\"coffee-findus\";s:3:\"zip\";s:23:\"packs/coffee-findus.zip\";s:3:\"uid\";s:32:\"96d3784473dfa64bce9e1e4101919927\";s:3:\"img\";s:24:\"coffee-findus/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:284;a:25:{s:2:\"id\";s:3:\"293\";s:5:\"title\";s:13:\"Coffee Footer\";s:5:\"alias\";s:13:\"coffee-footer\";s:3:\"zip\";s:23:\"packs/coffee-footer.zip\";s:3:\"uid\";s:32:\"6027c25e87a5fe7fd8727a51c0967915\";s:3:\"img\";s:24:\"coffee-footer/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:285;a:25:{s:2:\"id\";s:3:\"294\";s:5:\"title\";s:17:\"Minimal Portfolio\";s:5:\"alias\";s:25:\"minimal-portfolio-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:25:\"minimal-portfolio-package\";s:3:\"img\";s:38:\"packages/minimal_portfolio_package.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/minimal-portfolio-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">The Minimal Portfolio template is a slide based website with additional modal detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Minimal Portfolio\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"19\";s:9:\"installed\";b:0;}i:286;a:25:{s:2:\"id\";s:3:\"295\";s:5:\"title\";s:17:\"Minimal Portfolio\";s:5:\"alias\";s:17:\"minimal-portfolio\";s:3:\"zip\";s:27:\"packs/minimal-portfolio.zip\";s:3:\"uid\";s:32:\"183b97b301d5ff0b171c067a87c8a3f5\";s:3:\"img\";s:28:\"minimal-portfolio/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/minimal-portfolio-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">The Minimal Portfolio template is a slide based website with additional modal detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Minimal Portfolio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"19\";s:9:\"installed\";b:0;}i:287;a:25:{s:2:\"id\";s:3:\"296\";s:5:\"title\";s:23:\"Minimal Portfolio Modal\";s:5:\"alias\";s:23:\"minimal-portfolio-modal\";s:3:\"zip\";s:33:\"packs/minimal-portfolio-modal.zip\";s:3:\"uid\";s:32:\"6874e6cec3663670f209a8d8a4f26b16\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/minimal-portfolio-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">The Minimal Portfolio template is a slide based website with additional modal detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Minimal Portfolio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"19\";s:9:\"installed\";b:0;}i:288;a:25:{s:2:\"id\";s:3:\"297\";s:5:\"title\";s:23:\"Angled Business Website\";s:5:\"alias\";s:23:\"angled-business-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:31:\"angled-business-website-package\";s:3:\"img\";s:27:\"packages/angled_package.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:289;a:25:{s:2:\"id\";s:3:\"298\";s:5:\"title\";s:11:\"Angled Menu\";s:5:\"alias\";s:11:\"angled-menu\";s:3:\"zip\";s:21:\"packs/angled-menu.zip\";s:3:\"uid\";s:32:\"2fe0c4682d1231ee3918be9e4fcb1837\";s:3:\"img\";s:22:\"angled-menu/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:290;a:25:{s:2:\"id\";s:3:\"299\";s:5:\"title\";s:13:\"Angled Header\";s:5:\"alias\";s:13:\"angled-header\";s:3:\"zip\";s:23:\"packs/angled-header.zip\";s:3:\"uid\";s:32:\"09462601d4edca8dff899de6f666dc47\";s:3:\"img\";s:24:\"angled-header/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:291;a:25:{s:2:\"id\";s:3:\"300\";s:5:\"title\";s:11:\"Angled News\";s:5:\"alias\";s:11:\"angled-news\";s:3:\"zip\";s:21:\"packs/angled-news.zip\";s:3:\"uid\";s:32:\"b315105763ed91214cb2f0ac12615729\";s:3:\"img\";s:22:\"angled-news/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:292;a:25:{s:2:\"id\";s:3:\"301\";s:5:\"title\";s:15:\"Angled Services\";s:5:\"alias\";s:15:\"angled-services\";s:3:\"zip\";s:25:\"packs/angled-services.zip\";s:3:\"uid\";s:32:\"7605651c1487e1a6c32edc70017be8ad\";s:3:\"img\";s:26:\"angled-services/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:293;a:25:{s:2:\"id\";s:3:\"302\";s:5:\"title\";s:14:\"Angled Success\";s:5:\"alias\";s:14:\"angled-success\";s:3:\"zip\";s:24:\"packs/angled-success.zip\";s:3:\"uid\";s:32:\"9e3fa974a42ecf80e1ec6ff991fca430\";s:3:\"img\";s:25:\"angled-success/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:294;a:25:{s:2:\"id\";s:3:\"303\";s:5:\"title\";s:13:\"Angled Footer\";s:5:\"alias\";s:13:\"angled-footer\";s:3:\"zip\";s:23:\"packs/angled-footer.zip\";s:3:\"uid\";s:32:\"aed4eaa2f7883351ba9c9947feef153e\";s:3:\"img\";s:24:\"angled-footer/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:295;a:25:{s:2:\"id\";s:3:\"304\";s:5:\"title\";s:20:\"Angled Content Modal\";s:5:\"alias\";s:20:\"angled-content-modal\";s:3:\"zip\";s:30:\"packs/angled-content-modal.zip\";s:3:\"uid\";s:32:\"4ddc74515fdf84f974217e4ed47a7c66\";s:3:\"img\";s:31:\"angled-content-modal/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:296;a:22:{s:2:\"id\";s:3:\"312\";s:5:\"title\";s:24:\"Retouch Before and After\";s:5:\"alias\";s:7:\"Retouch\";s:3:\"zip\";s:11:\"Retouch.zip\";s:3:\"uid\";s:32:\"58894991f1abd8b448c8d353b1b5fe76\";s:3:\"img\";s:18:\"Retouch/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/retouch-before-after-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">The Retouch Slider is the perfect way to compare your photos before and after retouching.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:297;a:22:{s:2:\"id\";s:3:\"313\";s:5:\"title\";s:11:\"Tech Slider\";s:5:\"alias\";s:11:\"tech-slider\";s:3:\"zip\";s:15:\"tech-slider.zip\";s:3:\"uid\";s:32:\"a98e2b264f00a1116d21808c6a543162\";s:3:\"img\";s:22:\"tech-slider/slide1.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/tech-showcase-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">This classic slider module with sleek device mockups features a smooth parallax effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:298;a:25:{s:2:\"id\";s:3:\"314\";s:5:\"title\";s:19:\"Peak Agency Website\";s:5:\"alias\";s:19:\"peak-agency-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"peak-agency-website-package\";s:3:\"img\";s:25:\"packages/peak_package.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:299;a:25:{s:2:\"id\";s:3:\"315\";s:5:\"title\";s:11:\"Peak Header\";s:5:\"alias\";s:11:\"peak-header\";s:3:\"zip\";s:21:\"packs/peak-header.zip\";s:3:\"uid\";s:32:\"b721bd612e9fbc5182418ad3fd7d0808\";s:3:\"img\";s:22:\"peak-header/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:300;a:25:{s:2:\"id\";s:3:\"316\";s:5:\"title\";s:10:\"Peak About\";s:5:\"alias\";s:10:\"peak-about\";s:3:\"zip\";s:20:\"packs/peak-about.zip\";s:3:\"uid\";s:32:\"7e68b1012fb03490d45c7f79e8cb1b19\";s:3:\"img\";s:21:\"peak-about/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:301;a:25:{s:2:\"id\";s:3:\"317\";s:5:\"title\";s:14:\"Peak Portfolio\";s:5:\"alias\";s:14:\"peak-portfolio\";s:3:\"zip\";s:24:\"packs/peak-portfolio.zip\";s:3:\"uid\";s:32:\"6198d1885ba9e95221c33e404f21bdbc\";s:3:\"img\";s:25:\"peak-portfolio/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:302;a:25:{s:2:\"id\";s:3:\"318\";s:5:\"title\";s:11:\"Peak Footer\";s:5:\"alias\";s:11:\"peak-footer\";s:3:\"zip\";s:21:\"packs/peak-footer.zip\";s:3:\"uid\";s:32:\"2dead6897ad3b3a709b380d81242f76b\";s:3:\"img\";s:22:\"peak-footer/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:303;a:25:{s:2:\"id\";s:3:\"319\";s:5:\"title\";s:24:\"Modern Portfolio Website\";s:5:\"alias\";s:24:\"modern-portfolio-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:32:\"modern-portfolio-website-package\";s:3:\"img\";s:30:\"packages/portfolio-package.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:304;a:25:{s:2:\"id\";s:3:\"320\";s:5:\"title\";s:17:\"Portfolio Welcome\";s:5:\"alias\";s:17:\"portfolio-welcome\";s:3:\"zip\";s:27:\"packs/portfolio-welcome.zip\";s:3:\"uid\";s:32:\"97336b8785e4a7b27facaf1547e0464d\";s:3:\"img\";s:28:\"portfolio-welcome/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:305;a:25:{s:2:\"id\";s:3:\"321\";s:5:\"title\";s:15:\"Portfolio About\";s:5:\"alias\";s:15:\"portfolio-about\";s:3:\"zip\";s:25:\"packs/portfolio-about.zip\";s:3:\"uid\";s:32:\"5d3a4724fd453de5313ceb6696c1db62\";s:3:\"img\";s:26:\"portfolio-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:306;a:25:{s:2:\"id\";s:3:\"322\";s:5:\"title\";s:21:\"Portfolio Works Title\";s:5:\"alias\";s:21:\"portfolio-works-title\";s:3:\"zip\";s:31:\"packs/portfolio-works-title.zip\";s:3:\"uid\";s:32:\"cbb5c6e875cc1f25b463fdf89cabef28\";s:3:\"img\";s:32:\"portfolio-works-title/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:307;a:25:{s:2:\"id\";s:3:\"323\";s:5:\"title\";s:23:\"Portfolio Works Content\";s:5:\"alias\";s:23:\"portfolio-works-content\";s:3:\"zip\";s:33:\"packs/portfolio-works-content.zip\";s:3:\"uid\";s:32:\"5c87311128c7794ffa6ee07ea0648082\";s:3:\"img\";s:34:\"portfolio-works-content/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:308;a:25:{s:2:\"id\";s:3:\"324\";s:5:\"title\";s:18:\"Portfolio Contacts\";s:5:\"alias\";s:18:\"portfolio-contacts\";s:3:\"zip\";s:28:\"packs/portfolio-contacts.zip\";s:3:\"uid\";s:32:\"bd81feffad83b69218f7e837478038e5\";s:3:\"img\";s:29:\"portfolio-contacts/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:309;a:25:{s:2:\"id\";s:3:\"325\";s:5:\"title\";s:18:\"App Studio Website\";s:5:\"alias\";s:18:\"app-studio-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"app-studio-website-package\";s:3:\"img\";s:31:\"packages/App_Studio_package.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:310;a:25:{s:2:\"id\";s:3:\"326\";s:5:\"title\";s:18:\"App Studio Welcome\";s:5:\"alias\";s:18:\"App-Studio-Welcome\";s:3:\"zip\";s:28:\"packs/App-Studio-Welcome.zip\";s:3:\"uid\";s:32:\"2ce0f3c54214b04e6c3a9becfd59730c\";s:3:\"img\";s:29:\"App-Studio-Welcome/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:311;a:25:{s:2:\"id\";s:3:\"327\";s:5:\"title\";s:19:\"App Studio Services\";s:5:\"alias\";s:19:\"App-Studio-Services\";s:3:\"zip\";s:29:\"packs/App-Studio-Services.zip\";s:3:\"uid\";s:32:\"5df7776271ec69d2f9edaa6b842715a9\";s:3:\"img\";s:30:\"App-Studio-Services/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:312;a:25:{s:2:\"id\";s:3:\"328\";s:5:\"title\";s:16:\"App Studio About\";s:5:\"alias\";s:16:\"App-Studio-About\";s:3:\"zip\";s:26:\"packs/App-Studio-About.zip\";s:3:\"uid\";s:32:\"af8b84dc116c629df7bd89fc69271a2e\";s:3:\"img\";s:27:\"App-Studio-About/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:313;a:25:{s:2:\"id\";s:3:\"329\";s:5:\"title\";s:19:\"App Studio Contacts\";s:5:\"alias\";s:19:\"App-Studio-Contacts\";s:3:\"zip\";s:29:\"packs/App-Studio-Contacts.zip\";s:3:\"uid\";s:32:\"afbbd2214c983d314f3215a00db9198d\";s:3:\"img\";s:30:\"App-Studio-Contacts/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:314;a:22:{s:2:\"id\";s:3:\"330\";s:5:\"title\";s:14:\"Cube Animation\";s:5:\"alias\";s:14:\"cube-animation\";s:3:\"zip\";s:18:\"cube-animation.zip\";s:3:\"uid\";s:32:\"c03dd3cfc60479dfc6d79ddb64fa0ec5\";s:3:\"img\";s:25:\"cube-animation/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/cube-animation-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">A modern slider with text elements, cube animations and a striking call to action button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:315;a:25:{s:2:\"id\";s:3:\"331\";s:5:\"title\";s:13:\"Basic Website\";s:5:\"alias\";s:13:\"basic-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:21:\"basic-website-package\";s:3:\"img\";s:26:\"packages/basic_package.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:316;a:25:{s:2:\"id\";s:3:\"332\";s:5:\"title\";s:10:\"Basic Menu\";s:5:\"alias\";s:10:\"basic-menu\";s:3:\"zip\";s:20:\"packs/basic-menu.zip\";s:3:\"uid\";s:32:\"39277f53b2cb5ac644a1649b47c37270\";s:3:\"img\";s:21:\"basic-menu/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:317;a:25:{s:2:\"id\";s:3:\"333\";s:5:\"title\";s:12:\"Basic Header\";s:5:\"alias\";s:12:\"basic-header\";s:3:\"zip\";s:22:\"packs/basic-header.zip\";s:3:\"uid\";s:32:\"ad7a32dbccb0bdf9de64cf2adfa950a2\";s:3:\"img\";s:23:\"basic-header/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:318;a:25:{s:2:\"id\";s:3:\"334\";s:5:\"title\";s:13:\"Basic Content\";s:5:\"alias\";s:13:\"basic-content\";s:3:\"zip\";s:23:\"packs/basic-content.zip\";s:3:\"uid\";s:32:\"0b12f3b183a3c8206e3a7b28d2d93108\";s:3:\"img\";s:24:\"basic-content/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:319;a:25:{s:2:\"id\";s:3:\"335\";s:5:\"title\";s:14:\"Basic Carousel\";s:5:\"alias\";s:14:\"basic-carousel\";s:3:\"zip\";s:24:\"packs/basic-carousel.zip\";s:3:\"uid\";s:32:\"e4abb5c6d5cf914530575a982d3dfc14\";s:3:\"img\";s:25:\"basic-carousel/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:320;a:25:{s:2:\"id\";s:3:\"336\";s:5:\"title\";s:13:\"Basic Callout\";s:5:\"alias\";s:13:\"basic-callout\";s:3:\"zip\";s:23:\"packs/basic-callout.zip\";s:3:\"uid\";s:32:\"2ccc208b9322f5435d0f4ff64c6d9dab\";s:3:\"img\";s:24:\"basic-callout/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:321;a:25:{s:2:\"id\";s:3:\"337\";s:5:\"title\";s:10:\"Basic Grid\";s:5:\"alias\";s:10:\"basic-grid\";s:3:\"zip\";s:20:\"packs/basic-grid.zip\";s:3:\"uid\";s:32:\"3cb4b41d2992eba012921b8fb7c96daa\";s:3:\"img\";s:21:\"basic-grid/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:322;a:25:{s:2:\"id\";s:3:\"338\";s:5:\"title\";s:17:\"Basic Video Block\";s:5:\"alias\";s:17:\"basic-video-block\";s:3:\"zip\";s:27:\"packs/basic-video-block.zip\";s:3:\"uid\";s:32:\"e7c1d42b21819741f3e72c1325dae5ed\";s:3:\"img\";s:28:\"basic-video-block/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:323;a:25:{s:2:\"id\";s:3:\"339\";s:5:\"title\";s:12:\"Basic Footer\";s:5:\"alias\";s:12:\"basic-footer\";s:3:\"zip\";s:22:\"packs/basic-footer.zip\";s:3:\"uid\";s:32:\"ed8f6a554775ebace558af2f4f2dcbac\";s:3:\"img\";s:23:\"basic-footer/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:324;a:25:{s:2:\"id\";s:3:\"340\";s:5:\"title\";s:14:\"Basic Lightbox\";s:5:\"alias\";s:14:\"basic-lightbox\";s:3:\"zip\";s:24:\"packs/basic-lightbox.zip\";s:3:\"uid\";s:32:\"e4b025b300b1a8f417d04eb80113fac2\";s:3:\"img\";s:25:\"basic-lightbox/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:325;a:22:{s:2:\"id\";s:3:\"341\";s:5:\"title\";s:13:\"Nature Slider\";s:5:\"alias\";s:13:\"nature-slider\";s:3:\"zip\";s:17:\"nature-slider.zip\";s:3:\"uid\";s:32:\"eef1a4584ec1c3b8c26c305cca44e805\";s:3:\"img\";s:24:\"nature-slider/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/nature-explorer-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:151:\"<span class=\"ttm_content\">The Nature Explorer Slider Template uses the Distortion and Particle Effects Add-Ons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:356:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:326;a:22:{s:2:\"id\";s:3:\"342\";s:5:\"title\";s:11:\"Art Gallery\";s:5:\"alias\";s:11:\"art-gallery\";s:3:\"zip\";s:15:\"art-gallery.zip\";s:3:\"uid\";s:32:\"b8c5095ae3407337e6e5b2a8515e7d6e\";s:3:\"img\";s:22:\"art-gallery/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/art-gallery-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern slider with large, geometric elements and interesting mask animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:327;a:25:{s:2:\"id\";s:3:\"343\";s:5:\"title\";s:20:\"Construction Company\";s:5:\"alias\";s:28:\"construction-company-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:36:\"construction-company-website-package\";s:3:\"img\";s:33:\"packages/construction_package.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:328;a:25:{s:2:\"id\";s:3:\"344\";s:5:\"title\";s:19:\"Construction Header\";s:5:\"alias\";s:19:\"Construction-Header\";s:3:\"zip\";s:29:\"packs/Construction-Header.zip\";s:3:\"uid\";s:32:\"5c77de774b8f5487c1276c4a7b3dc80c\";s:3:\"img\";s:30:\"Construction-Header/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:329;a:25:{s:2:\"id\";s:3:\"345\";s:5:\"title\";s:17:\"Construction Home\";s:5:\"alias\";s:17:\"Construction-Home\";s:3:\"zip\";s:27:\"packs/Construction-Home.zip\";s:3:\"uid\";s:32:\"fcb277f0c07dad270d2a7cef4431bef8\";s:3:\"img\";s:28:\"Construction-Home/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:330;a:25:{s:2:\"id\";s:3:\"346\";s:5:\"title\";s:21:\"Construction Projects\";s:5:\"alias\";s:21:\"Construction-Projects\";s:3:\"zip\";s:31:\"packs/Construction-Projects.zip\";s:3:\"uid\";s:32:\"0c847173c3739f79778dc2c0fc9704e4\";s:3:\"img\";s:32:\"Construction-Projects/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:331;a:25:{s:2:\"id\";s:3:\"347\";s:5:\"title\";s:20:\"Construction History\";s:5:\"alias\";s:20:\"Construction-History\";s:3:\"zip\";s:30:\"packs/Construction-History.zip\";s:3:\"uid\";s:32:\"758da120c4b6c5606692faf0aa43aac6\";s:3:\"img\";s:31:\"Construction-History/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:332;a:25:{s:2:\"id\";s:3:\"348\";s:5:\"title\";s:21:\"Construction Services\";s:5:\"alias\";s:21:\"Construction-Services\";s:3:\"zip\";s:31:\"packs/Construction-Services.zip\";s:3:\"uid\";s:32:\"5ad5b841c1d89e97ddbf972c8b11abd4\";s:3:\"img\";s:32:\"Construction-Services/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:333;a:25:{s:2:\"id\";s:3:\"349\";s:5:\"title\";s:21:\"Construction Contacts\";s:5:\"alias\";s:21:\"Construction-Contacts\";s:3:\"zip\";s:31:\"packs/Construction-Contacts.zip\";s:3:\"uid\";s:32:\"b8c3c34046bb91ebb243e4da64745d37\";s:3:\"img\";s:32:\"Construction-Contacts/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:334;a:22:{s:2:\"id\";s:3:\"350\";s:5:\"title\";s:22:\"Classic Cars Evolution\";s:5:\"alias\";s:22:\"Classic-Cars-Evolution\";s:3:\"zip\";s:26:\"Classic-Cars-Evolution.zip\";s:3:\"uid\";s:32:\"7061757f128fd624b0227715dab73b74\";s:3:\"img\";s:33:\"Classic-Cars-Evolution/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/classic-cars-before-after-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:156:\"<span class=\"ttm_content\">The Classic Cars Evolution Slider is a great example of our popular before & after Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:335;a:22:{s:2:\"id\";s:3:\"351\";s:5:\"title\";s:21:\"404 Error Space Theme\";s:5:\"alias\";s:21:\"404-Error-Space-Theme\";s:3:\"zip\";s:25:\"404-Error-Space-Theme.zip\";s:3:\"uid\";s:32:\"6412adc7ec025826328e40e552a14e1e\";s:3:\"img\";s:32:\"404-Error-Space-Theme/slide1.jpg\";s:7:\"preview\";s:49:\"https://revolution.themepunch.com/404-error-page/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">The Classic Cars Evolution Slider is the perfect way to make your error page more beautiful.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:336;a:25:{s:2:\"id\";s:3:\"352\";s:5:\"title\";s:12:\"Landing Page\";s:5:\"alias\";s:20:\"landing-page-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"landing-page-website-package\";s:3:\"img\";s:23:\"packages/lp_package.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:337;a:25:{s:2:\"id\";s:3:\"353\";s:5:\"title\";s:17:\"Landing Page Hero\";s:5:\"alias\";s:17:\"landing-page-hero\";s:3:\"zip\";s:27:\"packs/landing-page-hero.zip\";s:3:\"uid\";s:32:\"d328635caa20da7ee8a3ab687f8656ff\";s:3:\"img\";s:28:\"landing-page-hero/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:338;a:25:{s:2:\"id\";s:3:\"354\";s:5:\"title\";s:21:\"Landing Page Features\";s:5:\"alias\";s:21:\"landing-page-features\";s:3:\"zip\";s:31:\"packs/landing-page-features.zip\";s:3:\"uid\";s:32:\"6552bc72abace10918a64866d9bb79c1\";s:3:\"img\";s:32:\"landing-page-features/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:339;a:25:{s:2:\"id\";s:3:\"355\";s:5:\"title\";s:20:\"Landing Page Callout\";s:5:\"alias\";s:20:\"landing-page-callout\";s:3:\"zip\";s:30:\"packs/landing-page-callout.zip\";s:3:\"uid\";s:32:\"c5b101ea5471e7409ae7effa8d45fbcf\";s:3:\"img\";s:31:\"landing-page-callout/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:340;a:25:{s:2:\"id\";s:3:\"356\";s:5:\"title\";s:20:\"Landing Page Content\";s:5:\"alias\";s:20:\"landing-page-content\";s:3:\"zip\";s:30:\"packs/landing-page-content.zip\";s:3:\"uid\";s:32:\"34da8057a6bb3677c9adf9f18ffc6cf0\";s:3:\"img\";s:31:\"landing-page-content/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:341;a:25:{s:2:\"id\";s:3:\"357\";s:5:\"title\";s:25:\"Landing Page Testimonials\";s:5:\"alias\";s:25:\"landing-page-testimonials\";s:3:\"zip\";s:35:\"packs/landing-page-testimonials.zip\";s:3:\"uid\";s:32:\"a83606e311cd5115422d86f04890cbf1\";s:3:\"img\";s:36:\"landing-page-testimonials/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:342;a:25:{s:2:\"id\";s:3:\"358\";s:5:\"title\";s:27:\"Landing Page Call to Action\";s:5:\"alias\";s:27:\"landing-page-call-to-action\";s:3:\"zip\";s:37:\"packs/landing-page-call-to-action.zip\";s:3:\"uid\";s:32:\"adfb456b27fa7eb6b1415d8f80836f05\";s:3:\"img\";s:38:\"landing-page-call-to-action/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:343;a:25:{s:2:\"id\";s:3:\"359\";s:5:\"title\";s:17:\"Landing Page Help\";s:5:\"alias\";s:17:\"landing-page-help\";s:3:\"zip\";s:27:\"packs/landing-page-help.zip\";s:3:\"uid\";s:32:\"ca502431f9b7f6249d99b02464de2dd7\";s:3:\"img\";s:28:\"landing-page-help/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:344;a:25:{s:2:\"id\";s:3:\"360\";s:5:\"title\";s:19:\"Landing Page Footer\";s:5:\"alias\";s:19:\"landing-page-footer\";s:3:\"zip\";s:29:\"packs/landing-page-footer.zip\";s:3:\"uid\";s:32:\"2a6afc371dbd60cb117f8a0f5d09eac9\";s:3:\"img\";s:30:\"landing-page-footer/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:345;a:25:{s:2:\"id\";s:3:\"361\";s:5:\"title\";s:24:\"Landing Page Price Modal\";s:5:\"alias\";s:24:\"landing-page-price-modal\";s:3:\"zip\";s:34:\"packs/landing-page-price-modal.zip\";s:3:\"uid\";s:32:\"a6c5c0430b46dd4e6e68416964a8c54d\";s:3:\"img\";s:35:\"landing-page-price-modal/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/landing-page-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:346;a:25:{s:2:\"id\";s:3:\"371\";s:5:\"title\";s:17:\"Corporate Website\";s:5:\"alias\";s:17:\"corporate-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:25:\"corporate-website-package\";s:3:\"img\";s:30:\"packages/corporate-website.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:347;a:25:{s:2:\"id\";s:3:\"372\";s:5:\"title\";s:16:\"Corporate Header\";s:5:\"alias\";s:16:\"Corporate-Header\";s:3:\"zip\";s:26:\"packs/Corporate-Header.zip\";s:3:\"uid\";s:32:\"04f868e3812a1681f00ab89580e5d1f8\";s:3:\"img\";s:27:\"Corporate-Header/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:348;a:25:{s:2:\"id\";s:3:\"373\";s:5:\"title\";s:24:\"Corporate Welcome Screen\";s:5:\"alias\";s:24:\"Corporate-Welcome-Screen\";s:3:\"zip\";s:34:\"packs/Corporate-Welcome-Screen.zip\";s:3:\"uid\";s:32:\"052afe98ef819f7ace041dbbdb749639\";s:3:\"img\";s:35:\"Corporate-Welcome-Screen/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:349;a:25:{s:2:\"id\";s:3:\"374\";s:5:\"title\";s:15:\"Corporate About\";s:5:\"alias\";s:15:\"Corporate-About\";s:3:\"zip\";s:25:\"packs/Corporate-About.zip\";s:3:\"uid\";s:32:\"7bf5f8f6d4cc3016cea86289cb46e5b6\";s:3:\"img\";s:26:\"Corporate-About/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:350;a:25:{s:2:\"id\";s:3:\"375\";s:5:\"title\";s:19:\"Corporate Portfolio\";s:5:\"alias\";s:19:\"Corporate-Portfolio\";s:3:\"zip\";s:29:\"packs/Corporate-Portfolio.zip\";s:3:\"uid\";s:32:\"612c2bd784fea81392dda1644a3c3cf3\";s:3:\"img\";s:30:\"Corporate-Portfolio/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:351;a:25:{s:2:\"id\";s:3:\"376\";s:5:\"title\";s:15:\"Corporate Chart\";s:5:\"alias\";s:15:\"Corporate-Chart\";s:3:\"zip\";s:25:\"packs/Corporate-Chart.zip\";s:3:\"uid\";s:32:\"4d27d9b3b2cfcce750e526aafb322a9f\";s:3:\"img\";s:26:\"Corporate-Chart/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:352;a:25:{s:2:\"id\";s:3:\"377\";s:5:\"title\";s:14:\"Corporate News\";s:5:\"alias\";s:14:\"Corporate-News\";s:3:\"zip\";s:24:\"packs/Corporate-News.zip\";s:3:\"uid\";s:32:\"bb65ed57a0d4db795d8b738f0a92f2d7\";s:3:\"img\";s:25:\"Corporate-News/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:353;a:25:{s:2:\"id\";s:3:\"378\";s:5:\"title\";s:16:\"Corporate Hiring\";s:5:\"alias\";s:16:\"Corporate-Hiring\";s:3:\"zip\";s:26:\"packs/Corporate-Hiring.zip\";s:3:\"uid\";s:32:\"136cf1a91604e819089eb3573a6e100a\";s:3:\"img\";s:27:\"Corporate-Hiring/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:354;a:25:{s:2:\"id\";s:3:\"379\";s:5:\"title\";s:22:\"Corporate Testimonials\";s:5:\"alias\";s:22:\"Corporate-Testimonials\";s:3:\"zip\";s:32:\"packs/Corporate-Testimonials.zip\";s:3:\"uid\";s:32:\"b17aec0afdc31e37359cfa406164463c\";s:3:\"img\";s:33:\"Corporate-Testimonials/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:355;a:25:{s:2:\"id\";s:3:\"380\";s:5:\"title\";s:15:\"Corporate Store\";s:5:\"alias\";s:15:\"Corporate-Store\";s:3:\"zip\";s:25:\"packs/Corporate-Store.zip\";s:3:\"uid\";s:32:\"6240b14620ddc634736716e0cdfdeb31\";s:3:\"img\";s:26:\"Corporate-Store/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:356;a:25:{s:2:\"id\";s:3:\"381\";s:5:\"title\";s:17:\"Corporate Support\";s:5:\"alias\";s:17:\"Corporate-Support\";s:3:\"zip\";s:27:\"packs/Corporate-Support.zip\";s:3:\"uid\";s:32:\"9424292a78076ce68c2faf587b26cdad\";s:3:\"img\";s:28:\"Corporate-Support/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:357;a:25:{s:2:\"id\";s:3:\"382\";s:5:\"title\";s:14:\"Corporate Team\";s:5:\"alias\";s:14:\"Corporate-Team\";s:3:\"zip\";s:24:\"packs/Corporate-Team.zip\";s:3:\"uid\";s:32:\"4fafe469b5a0a2545625c3f6d7ff3b9e\";s:3:\"img\";s:25:\"Corporate-Team/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"11\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:358;a:25:{s:2:\"id\";s:3:\"383\";s:5:\"title\";s:33:\"Corporate Selected Projects Title\";s:5:\"alias\";s:33:\"Corporate-Selected-Projects-Title\";s:3:\"zip\";s:43:\"packs/Corporate-Selected-Projects-Title.zip\";s:3:\"uid\";s:32:\"0ed3c41f51e6bf404c2fe179fa8d8ceb\";s:3:\"img\";s:44:\"Corporate-Selected-Projects-Title/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"12\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:359;a:25:{s:2:\"id\";s:3:\"384\";s:5:\"title\";s:27:\"Corporate Selected Projects\";s:5:\"alias\";s:27:\"Corporate-Selected-Projects\";s:3:\"zip\";s:37:\"packs/Corporate-Selected-Projects.zip\";s:3:\"uid\";s:32:\"1096c78d5f007f3900228a4092515e2e\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"13\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:360;a:25:{s:2:\"id\";s:3:\"385\";s:5:\"title\";s:17:\"Corporate Clients\";s:5:\"alias\";s:17:\"Corporate-Clients\";s:3:\"zip\";s:27:\"packs/Corporate-Clients.zip\";s:3:\"uid\";s:32:\"60fe3a311195bf4dba3e50bd1ab98574\";s:3:\"img\";s:28:\"Corporate-Clients/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"14\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:361;a:25:{s:2:\"id\";s:3:\"386\";s:5:\"title\";s:20:\"Corporate Text Block\";s:5:\"alias\";s:20:\"Corporate-Text-Block\";s:3:\"zip\";s:30:\"packs/Corporate-Text-Block.zip\";s:3:\"uid\";s:32:\"93b68bb23d65fd1028b6b5f6d19b85b5\";s:3:\"img\";s:31:\"Corporate-Text-Block/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"15\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:362;a:25:{s:2:\"id\";s:3:\"387\";s:5:\"title\";s:20:\"Corporate Mobile App\";s:5:\"alias\";s:20:\"Corporate-Mobile-App\";s:3:\"zip\";s:30:\"packs/Corporate-Mobile-App.zip\";s:3:\"uid\";s:32:\"e592369d233bea673403daa15c6e498a\";s:3:\"img\";s:31:\"Corporate-Mobile-App/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"16\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:363;a:25:{s:2:\"id\";s:3:\"388\";s:5:\"title\";s:18:\"Corporate Contacts\";s:5:\"alias\";s:18:\"Corporate-Contacts\";s:3:\"zip\";s:28:\"packs/Corporate-Contacts.zip\";s:3:\"uid\";s:32:\"91ae9488b54b7020f8ae9dfbfd6c563a\";s:3:\"img\";s:29:\"Corporate-Contacts/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"17\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:364;a:25:{s:2:\"id\";s:3:\"389\";s:5:\"title\";s:16:\"Corporate Footer\";s:5:\"alias\";s:16:\"Corporate-Footer\";s:3:\"zip\";s:26:\"packs/Corporate-Footer.zip\";s:3:\"uid\";s:32:\"a01df90af203f06194c1a18745d79861\";s:3:\"img\";s:27:\"Corporate-Footer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"18\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:365;a:25:{s:2:\"id\";s:3:\"390\";s:5:\"title\";s:23:\"Corporate Scroll To Top\";s:5:\"alias\";s:23:\"Corporate-Scroll-To-Top\";s:3:\"zip\";s:33:\"packs/Corporate-Scroll-To-Top.zip\";s:3:\"uid\";s:32:\"2d68f6e4590a9a445e6eb055dfee88ba\";s:3:\"img\";s:34:\"Corporate-Scroll-To-Top/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/corporate-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:206:\"<span class=\"ttm_content\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"19\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:366;a:25:{s:2:\"id\";s:3:\"402\";s:5:\"title\";s:23:\"Brutal Website Template\";s:5:\"alias\";s:23:\"brutal-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:31:\"brutal-website-template-package\";s:3:\"img\";s:36:\"packages/brutal-website-template.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:367;a:25:{s:2:\"id\";s:3:\"403\";s:5:\"title\";s:11:\"Brutal Menu\";s:5:\"alias\";s:11:\"brutal-menu\";s:3:\"zip\";s:21:\"packs/brutal-menu.zip\";s:3:\"uid\";s:32:\"04b21c7aee2479793336e964230d6e3f\";s:3:\"img\";s:22:\"brutal-menu/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:368;a:25:{s:2:\"id\";s:3:\"404\";s:5:\"title\";s:11:\"Brutal Hero\";s:5:\"alias\";s:11:\"brutal-hero\";s:3:\"zip\";s:21:\"packs/brutal-hero.zip\";s:3:\"uid\";s:32:\"a342ad01054b97bac7980fdf9e275b34\";s:3:\"img\";s:22:\"brutal-hero/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:369;a:25:{s:2:\"id\";s:3:\"405\";s:5:\"title\";s:12:\"Brutal About\";s:5:\"alias\";s:12:\"brutal-about\";s:3:\"zip\";s:22:\"packs/brutal-about.zip\";s:3:\"uid\";s:32:\"a3e1cd2e36c9a783c1932fdafe2e4434\";s:3:\"img\";s:23:\"brutal-about/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:370;a:25:{s:2:\"id\";s:3:\"406\";s:5:\"title\";s:16:\"Brutal Highlight\";s:5:\"alias\";s:16:\"brutal-highlight\";s:3:\"zip\";s:26:\"packs/brutal-highlight.zip\";s:3:\"uid\";s:32:\"b7f8522dcb4636467633bd3b14f4e3e9\";s:3:\"img\";s:27:\"brutal-highlight/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:371;a:25:{s:2:\"id\";s:3:\"407\";s:5:\"title\";s:15:\"Brutal Projects\";s:5:\"alias\";s:15:\"brutal-projects\";s:3:\"zip\";s:25:\"packs/brutal-projects.zip\";s:3:\"uid\";s:32:\"1a462e91373042193ca5d623dd8e8a47\";s:3:\"img\";s:26:\"brutal-projects/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:372;a:25:{s:2:\"id\";s:3:\"408\";s:5:\"title\";s:15:\"Brutal Services\";s:5:\"alias\";s:15:\"brutal-services\";s:3:\"zip\";s:25:\"packs/brutal-services.zip\";s:3:\"uid\";s:32:\"cbeeb1e7a5c2842b155fe13acb7c165d\";s:3:\"img\";s:26:\"brutal-services/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:373;a:25:{s:2:\"id\";s:3:\"409\";s:5:\"title\";s:14:\"Brutal Callout\";s:5:\"alias\";s:14:\"brutal-callout\";s:3:\"zip\";s:24:\"packs/brutal-callout.zip\";s:3:\"uid\";s:32:\"31b6dafdb2dfb548152653e60df5a3bc\";s:3:\"img\";s:25:\"brutal-callout/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:374;a:25:{s:2:\"id\";s:3:\"410\";s:5:\"title\";s:13:\"Brutal Footer\";s:5:\"alias\";s:13:\"brutal-footer\";s:3:\"zip\";s:23:\"packs/brutal-footer.zip\";s:3:\"uid\";s:32:\"07559f0c574e3dd95b2d40d72cbb01bc\";s:3:\"img\";s:24:\"brutal-footer/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/brutal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;}i:375;a:25:{s:2:\"id\";s:3:\"411\";s:5:\"title\";s:23:\"Church Website Template\";s:5:\"alias\";s:23:\"church-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:31:\"church-website-template-package\";s:3:\"img\";s:36:\"packages/church-website-template.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:376;a:25:{s:2:\"id\";s:3:\"412\";s:5:\"title\";s:13:\"Church Header\";s:5:\"alias\";s:13:\"Church-Header\";s:3:\"zip\";s:23:\"packs/Church-Header.zip\";s:3:\"uid\";s:32:\"c14289117e1e2b9ee716fb99146b2e03\";s:3:\"img\";s:24:\"Church-Header/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:377;a:25:{s:2:\"id\";s:3:\"413\";s:5:\"title\";s:22:\"Church Upcoming Events\";s:5:\"alias\";s:22:\"Church-Upcoming-Events\";s:3:\"zip\";s:32:\"packs/Church-Upcoming-Events.zip\";s:3:\"uid\";s:32:\"056a26efddae92973fee4ee5cfa75f10\";s:3:\"img\";s:33:\"Church-Upcoming-Events/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:378;a:25:{s:2:\"id\";s:3:\"414\";s:5:\"title\";s:12:\"Church About\";s:5:\"alias\";s:12:\"Church-About\";s:3:\"zip\";s:22:\"packs/Church-About.zip\";s:3:\"uid\";s:32:\"8ef133f3f669f06380334a83e27eedbb\";s:3:\"img\";s:23:\"Church-About/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:379;a:25:{s:2:\"id\";s:3:\"415\";s:5:\"title\";s:14:\"Church Pastors\";s:5:\"alias\";s:14:\"Church-Pastors\";s:3:\"zip\";s:24:\"packs/Church-Pastors.zip\";s:3:\"uid\";s:32:\"715edc0833a753b72350b8c974f86f94\";s:3:\"img\";s:25:\"Church-Pastors/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:380;a:25:{s:2:\"id\";s:3:\"416\";s:5:\"title\";s:20:\"Church Photo Gallery\";s:5:\"alias\";s:20:\"Church-Photo-Gallery\";s:3:\"zip\";s:30:\"packs/Church-Photo-Gallery.zip\";s:3:\"uid\";s:32:\"d94808a97149cd5d3b3354a28409ffd7\";s:3:\"img\";s:31:\"Church-Photo-Gallery/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:381;a:25:{s:2:\"id\";s:3:\"417\";s:5:\"title\";s:16:\"Church Community\";s:5:\"alias\";s:16:\"Church-Community\";s:3:\"zip\";s:26:\"packs/Church-Community.zip\";s:3:\"uid\";s:32:\"2244e6a6d7a691653eae2d70765130a7\";s:3:\"img\";s:27:\"Church-Community/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:382;a:25:{s:2:\"id\";s:3:\"418\";s:5:\"title\";s:13:\"Church Sermon\";s:5:\"alias\";s:13:\"Church-Sermon\";s:3:\"zip\";s:23:\"packs/Church-Sermon.zip\";s:3:\"uid\";s:32:\"8fedf983bd55fff0f7a16d9f0a7e5408\";s:3:\"img\";s:24:\"Church-Sermon/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:383;a:25:{s:2:\"id\";s:3:\"419\";s:5:\"title\";s:15:\"Church Contacts\";s:5:\"alias\";s:15:\"Church-Contacts\";s:3:\"zip\";s:25:\"packs/Church-Contacts.zip\";s:3:\"uid\";s:32:\"0b1a6968e75868548fd98e435625c090\";s:3:\"img\";s:26:\"Church-Contacts/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:384;a:25:{s:2:\"id\";s:3:\"420\";s:5:\"title\";s:13:\"Church Footer\";s:5:\"alias\";s:13:\"Church-Footer\";s:3:\"zip\";s:23:\"packs/Church-Footer.zip\";s:3:\"uid\";s:32:\"29756685d3dc49e42edada43e6393b7b\";s:3:\"img\";s:24:\"Church-Footer/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/church-website-template-dark/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:385;a:25:{s:2:\"id\";s:3:\"421\";s:5:\"title\";s:29:\"Church Light Website Template\";s:5:\"alias\";s:29:\"church-light-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:37:\"church-light-website-template-package\";s:3:\"img\";s:42:\"packages/church-light-website-template.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:386;a:25:{s:2:\"id\";s:3:\"422\";s:5:\"title\";s:19:\"Church Light Header\";s:5:\"alias\";s:19:\"Church-Light-Header\";s:3:\"zip\";s:29:\"packs/Church-Light-Header.zip\";s:3:\"uid\";s:32:\"81c00f4b52cf55214de919e3f13121fc\";s:3:\"img\";s:30:\"Church-Light-Header/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:387;a:25:{s:2:\"id\";s:3:\"423\";s:5:\"title\";s:28:\"Church Light Upcoming Events\";s:5:\"alias\";s:28:\"Church-Light-Upcoming-Events\";s:3:\"zip\";s:38:\"packs/Church-Light-Upcoming-Events.zip\";s:3:\"uid\";s:32:\"963a49f4be0557ac5f3ee61d256f5bda\";s:3:\"img\";s:39:\"Church-Light-Upcoming-Events/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:388;a:25:{s:2:\"id\";s:3:\"424\";s:5:\"title\";s:18:\"Church Light About\";s:5:\"alias\";s:18:\"Church-Light-About\";s:3:\"zip\";s:28:\"packs/Church-Light-About.zip\";s:3:\"uid\";s:32:\"d46c8e8e6f80e6bfedb54f1cdc49e7e6\";s:3:\"img\";s:29:\"Church-Light-About/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:389;a:25:{s:2:\"id\";s:3:\"425\";s:5:\"title\";s:20:\"Church Light Pastors\";s:5:\"alias\";s:20:\"Church-Light-Pastors\";s:3:\"zip\";s:30:\"packs/Church-Light-Pastors.zip\";s:3:\"uid\";s:32:\"7cc3dec61556e2291d6f38c1ea5e983f\";s:3:\"img\";s:31:\"Church-Light-Pastors/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:390;a:25:{s:2:\"id\";s:3:\"426\";s:5:\"title\";s:26:\"Church Light Photo Gallery\";s:5:\"alias\";s:26:\"Church-Light-Photo-Gallery\";s:3:\"zip\";s:36:\"packs/Church-Light-Photo-Gallery.zip\";s:3:\"uid\";s:32:\"9e13100179b9b700b005693eeca57902\";s:3:\"img\";s:37:\"Church-Light-Photo-Gallery/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:391;a:25:{s:2:\"id\";s:3:\"427\";s:5:\"title\";s:22:\"Church Light Community\";s:5:\"alias\";s:22:\"Church-Light-Community\";s:3:\"zip\";s:32:\"packs/Church-Light-Community.zip\";s:3:\"uid\";s:32:\"14fcc0d43d899fd96116bdbc57c7c5ea\";s:3:\"img\";s:33:\"Church-Light-Community/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:392;a:25:{s:2:\"id\";s:3:\"428\";s:5:\"title\";s:19:\"Church Light Sermon\";s:5:\"alias\";s:19:\"Church-Light-Sermon\";s:3:\"zip\";s:29:\"packs/Church-Light-Sermon.zip\";s:3:\"uid\";s:32:\"fc30be7e703bc7b235665c36baa80e4e\";s:3:\"img\";s:30:\"Church-Light-Sermon/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:393;a:25:{s:2:\"id\";s:3:\"429\";s:5:\"title\";s:21:\"Church Light Contacts\";s:5:\"alias\";s:21:\"Church-Light-Contacts\";s:3:\"zip\";s:31:\"packs/Church-Light-Contacts.zip\";s:3:\"uid\";s:32:\"ed83d8fa63ecb59cf42656068ecf8d25\";s:3:\"img\";s:32:\"Church-Light-Contacts/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:394;a:25:{s:2:\"id\";s:3:\"430\";s:5:\"title\";s:19:\"Church Light Footer\";s:5:\"alias\";s:19:\"Church-Light-Footer\";s:3:\"zip\";s:29:\"packs/Church-Light-Footer.zip\";s:3:\"uid\";s:32:\"a168772865fd5dcf6229c9c6a49dff73\";s:3:\"img\";s:30:\"Church-Light-Footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/church-website-template-light/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:395;a:25:{s:2:\"id\";s:3:\"431\";s:5:\"title\";s:25:\"Rockable Website Template\";s:5:\"alias\";s:25:\"rockable-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:33:\"rockable-website-template-package\";s:3:\"img\";s:38:\"packages/rockable-website-template.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:396;a:25:{s:2:\"id\";s:3:\"432\";s:5:\"title\";s:13:\"Rockable Menu\";s:5:\"alias\";s:13:\"rockable-menu\";s:3:\"zip\";s:23:\"packs/rockable-menu.zip\";s:3:\"uid\";s:32:\"92d18f7ff38f22ff411a4ef4d9f54934\";s:3:\"img\";s:24:\"rockable-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:397;a:25:{s:2:\"id\";s:3:\"433\";s:5:\"title\";s:13:\"Rockable Hero\";s:5:\"alias\";s:13:\"rockable-hero\";s:3:\"zip\";s:23:\"packs/rockable-hero.zip\";s:3:\"uid\";s:32:\"ba16b28d6bde95910cbce572bb251208\";s:3:\"img\";s:24:\"rockable-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:398;a:25:{s:2:\"id\";s:3:\"434\";s:5:\"title\";s:15:\"Rockable Lineup\";s:5:\"alias\";s:15:\"rockable-lineup\";s:3:\"zip\";s:25:\"packs/rockable-lineup.zip\";s:3:\"uid\";s:32:\"6631980112805533a0d328c37e56adbd\";s:3:\"img\";s:26:\"rockable-lineup/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:399;a:25:{s:2:\"id\";s:3:\"435\";s:5:\"title\";s:17:\"Rockable Lineup 2\";s:5:\"alias\";s:17:\"rockable-lineup-2\";s:3:\"zip\";s:27:\"packs/rockable-lineup-2.zip\";s:3:\"uid\";s:32:\"98bc41d982dc478edabff4aa99461dbc\";s:3:\"img\";s:28:\"rockable-lineup-2/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:400;a:25:{s:2:\"id\";s:3:\"436\";s:5:\"title\";s:22:\"Rockable Gallery Title\";s:5:\"alias\";s:22:\"rockable-gallery-title\";s:3:\"zip\";s:32:\"packs/rockable-gallery-title.zip\";s:3:\"uid\";s:32:\"da43a76f5bc77aa6efe158b00ab7cf0d\";s:3:\"img\";s:33:\"rockable-gallery-title/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:401;a:25:{s:2:\"id\";s:3:\"437\";s:5:\"title\";s:16:\"Rockable Gallery\";s:5:\"alias\";s:16:\"rockable-gallery\";s:3:\"zip\";s:26:\"packs/rockable-gallery.zip\";s:3:\"uid\";s:32:\"c12a144d6860bcf24e91d5b980ac22f1\";s:3:\"img\";s:27:\"rockable-gallery/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:402;a:25:{s:2:\"id\";s:3:\"438\";s:5:\"title\";s:17:\"Rockable Sponsors\";s:5:\"alias\";s:17:\"rockable-sponsors\";s:3:\"zip\";s:27:\"packs/rockable-sponsors.zip\";s:3:\"uid\";s:32:\"1e40d4a810c23f8d5fe5cd5ca31ee20d\";s:3:\"img\";s:28:\"rockable-sponsors/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:403;a:25:{s:2:\"id\";s:3:\"439\";s:5:\"title\";s:15:\"Rockable Footer\";s:5:\"alias\";s:15:\"rockable-footer\";s:3:\"zip\";s:25:\"packs/rockable-footer.zip\";s:3:\"uid\";s:32:\"a4a9952d5e56fc14366155e8ebfa432a\";s:3:\"img\";s:26:\"rockable-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:404;a:25:{s:2:\"id\";s:3:\"440\";s:5:\"title\";s:21:\"Rockable Detail Modal\";s:5:\"alias\";s:21:\"rockable-detail-modal\";s:3:\"zip\";s:31:\"packs/rockable-detail-modal.zip\";s:3:\"uid\";s:32:\"b51d918203ff7975a144a9f1be09f31b\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:405;a:25:{s:2:\"id\";s:3:\"441\";s:5:\"title\";s:23:\"Rockable Detail Modal 2\";s:5:\"alias\";s:23:\"rockable-detail-modal-2\";s:3:\"zip\";s:33:\"packs/rockable-detail-modal-2.zip\";s:3:\"uid\";s:32:\"dcf51ebb3d4a1dec94748a1e016c5ef7\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/rockable-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:406;a:22:{s:2:\"id\";s:3:\"442\";s:5:\"title\";s:27:\"Real Estate Showcase Slider\";s:5:\"alias\";s:27:\"Real-Estate-Showcase-Slider\";s:3:\"zip\";s:31:\"Real-Estate-Showcase-Slider.zip\";s:3:\"uid\";s:32:\"4b0ddbe1928115f4b040f6ad4a01a583\";s:3:\"img\";s:38:\"Real-Estate-Showcase-Slider/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/real-estate-showcase-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">An elegant showcase for your real estate & realtor website. Flexible and customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:407;a:22:{s:2:\"id\";s:3:\"443\";s:5:\"title\";s:16:\"Isometric Slider\";s:5:\"alias\";s:16:\"isometric-slider\";s:3:\"zip\";s:20:\"isometric-slider.zip\";s:3:\"uid\";s:32:\"fb06051fcf6649a44f2292044e414a36\";s:3:\"img\";s:27:\"isometric-slider/slide1.jpg\";s:7:\"preview\";s:51:\"https://revolution.themepunch.com/isometric-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:154:\"<span class=\"ttm_content\">A colorful, isometric slider template with fully customizable colors and screen content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:408;a:25:{s:2:\"id\";s:3:\"444\";s:5:\"title\";s:26:\"Woo Commerce Slider Static\";s:5:\"alias\";s:26:\"woo-commerce-slider-static\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"woo-commerce-slider-static\";s:3:\"img\";s:39:\"packages/woo-commerce-slider-static.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/woo-commerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:178:\"<span class=\"ttm_content\">A uniquely animated Woo Commerce Slider template - this is the static version that doesn\'t use Woo Commerce data</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Woo Commerce Slider Static\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"35\";s:9:\"installed\";b:0;}i:409;a:25:{s:2:\"id\";s:3:\"445\";s:5:\"title\";s:17:\"E-Commerce Slider\";s:5:\"alias\";s:17:\"E-Commerce-Slider\";s:3:\"zip\";s:27:\"packs/E-Commerce-Slider.zip\";s:3:\"uid\";s:32:\"1533cfd83c2ae122f23074e1ed77f256\";s:3:\"img\";s:28:\"E-Commerce-Slider/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/woo-commerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:178:\"<span class=\"ttm_content\">A uniquely animated Woo Commerce Slider template - this is the static version that doesn\'t use Woo Commerce data</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Woo Commerce Slider Static\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"35\";s:9:\"installed\";b:0;}i:410;a:25:{s:2:\"id\";s:3:\"446\";s:5:\"title\";s:23:\"E-Commerce Slider Modal\";s:5:\"alias\";s:23:\"E-Commerce-Slider-Modal\";s:3:\"zip\";s:33:\"packs/E-Commerce-Slider-Modal.zip\";s:3:\"uid\";s:32:\"825e05c3967515b92a75da017c68a863\";s:3:\"img\";s:34:\"E-Commerce-Slider-Modal/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/woo-commerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:178:\"<span class=\"ttm_content\">A uniquely animated Woo Commerce Slider template - this is the static version that doesn\'t use Woo Commerce data</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Woo Commerce Slider Static\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"35\";s:9:\"installed\";b:0;}i:411;a:22:{s:2:\"id\";s:3:\"447\";s:5:\"title\";s:27:\"Woo Commerce Slider Dynamic\";s:5:\"alias\";s:27:\"Woo-Commerce-Slider-Dynamic\";s:3:\"zip\";s:31:\"Woo-Commerce-Slider-Dynamic.zip\";s:3:\"uid\";s:32:\"b8e2c64f3739e552c563c48c59f20fe7\";s:3:\"img\";s:38:\"Woo-Commerce-Slider-Dynamic/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/woo-commerce-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">A uniquely animated Woo Commerce Slider template - this is the dynamic version that uses Woo Commerce data</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:412;a:25:{s:2:\"id\";s:3:\"448\";s:5:\"title\";s:31:\"Blooming Event Florist Template\";s:5:\"alias\";s:31:\"blooming-event-florist-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:39:\"blooming-event-florist-template-package\";s:3:\"img\";s:52:\"packages/blooming-event-florist-template-package.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:413;a:25:{s:2:\"id\";s:3:\"449\";s:5:\"title\";s:15:\"Blooming Header\";s:5:\"alias\";s:15:\"blooming-header\";s:3:\"zip\";s:25:\"packs/blooming-header.zip\";s:3:\"uid\";s:32:\"aa2ee34fd8ed018945ba64e6913810e4\";s:3:\"img\";s:26:\"blooming-header/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:414;a:25:{s:2:\"id\";s:3:\"450\";s:5:\"title\";s:14:\"Blooming About\";s:5:\"alias\";s:14:\"blooming-about\";s:3:\"zip\";s:24:\"packs/blooming-about.zip\";s:3:\"uid\";s:32:\"dd7095e46fab2eb475d00480fd17a6ec\";s:3:\"img\";s:25:\"blooming-about/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:415;a:25:{s:2:\"id\";s:3:\"451\";s:5:\"title\";s:18:\"Blooming Portfolio\";s:5:\"alias\";s:18:\"blooming-portfolio\";s:3:\"zip\";s:28:\"packs/blooming-portfolio.zip\";s:3:\"uid\";s:32:\"c72ddcbb07b62982b8c21328a6383e22\";s:3:\"img\";s:29:\"blooming-portfolio/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:416;a:25:{s:2:\"id\";s:3:\"452\";s:5:\"title\";s:22:\"Blooming Wedding Title\";s:5:\"alias\";s:22:\"blooming-wedding-title\";s:3:\"zip\";s:32:\"packs/blooming-wedding-title.zip\";s:3:\"uid\";s:32:\"4fcfb0b99289c12d014c67306bb7687b\";s:3:\"img\";s:33:\"blooming-wedding-title/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:417;a:25:{s:2:\"id\";s:3:\"453\";s:5:\"title\";s:25:\"Blooming Wedding Carousel\";s:5:\"alias\";s:25:\"blooming-wedding-carousel\";s:3:\"zip\";s:35:\"packs/blooming-wedding-carousel.zip\";s:3:\"uid\";s:32:\"1d1bb979dbfca8ba9d43da1c0f665339\";s:3:\"img\";s:36:\"blooming-wedding-carousel/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:418;a:25:{s:2:\"id\";s:3:\"454\";s:5:\"title\";s:21:\"Blooming Wedding Text\";s:5:\"alias\";s:21:\"blooming-wedding-text\";s:3:\"zip\";s:31:\"packs/blooming-wedding-text.zip\";s:3:\"uid\";s:32:\"326f2793294a739dd3aac3cc45332df8\";s:3:\"img\";s:32:\"blooming-wedding-text/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:419;a:25:{s:2:\"id\";s:3:\"455\";s:5:\"title\";s:22:\"Blooming Parties Title\";s:5:\"alias\";s:22:\"blooming-parties-title\";s:3:\"zip\";s:32:\"packs/blooming-parties-title.zip\";s:3:\"uid\";s:32:\"b47aae1b368d3c3d9017f260e6c6a547\";s:3:\"img\";s:33:\"blooming-parties-title/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:420;a:25:{s:2:\"id\";s:3:\"456\";s:5:\"title\";s:25:\"Blooming Parties Carousel\";s:5:\"alias\";s:25:\"blooming-parties-carousel\";s:3:\"zip\";s:35:\"packs/blooming-parties-carousel.zip\";s:3:\"uid\";s:32:\"9f90a9da7b017aeee7f3b608cda066e6\";s:3:\"img\";s:36:\"blooming-parties-carousel/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:421;a:25:{s:2:\"id\";s:3:\"457\";s:5:\"title\";s:21:\"Blooming Parties Text\";s:5:\"alias\";s:21:\"blooming-parties-text\";s:3:\"zip\";s:31:\"packs/blooming-parties-text.zip\";s:3:\"uid\";s:32:\"66a47346cc639b8b9b9b5dfa1521b6ef\";s:3:\"img\";s:32:\"blooming-parties-text/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:422;a:25:{s:2:\"id\";s:3:\"458\";s:5:\"title\";s:22:\"Blooming Funeral Title\";s:5:\"alias\";s:22:\"blooming-funeral-title\";s:3:\"zip\";s:32:\"packs/blooming-funeral-title.zip\";s:3:\"uid\";s:32:\"e9e77134472c33c56be442073f29d1fd\";s:3:\"img\";s:33:\"blooming-funeral-title/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:423;a:25:{s:2:\"id\";s:3:\"459\";s:5:\"title\";s:23:\"Blooming Funeral Slider\";s:5:\"alias\";s:23:\"blooming-funeral-slider\";s:3:\"zip\";s:33:\"packs/blooming-funeral-slider.zip\";s:3:\"uid\";s:32:\"d15090841c25c7c8f0e1b0987c0c0887\";s:3:\"img\";s:34:\"blooming-funeral-slider/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:2:\"11\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:424;a:25:{s:2:\"id\";s:3:\"460\";s:5:\"title\";s:21:\"Blooming Funeral Text\";s:5:\"alias\";s:21:\"blooming-funeral-text\";s:3:\"zip\";s:31:\"packs/blooming-funeral-text.zip\";s:3:\"uid\";s:32:\"d7c80e246f31e3d2f4e5dc1656f133cc\";s:3:\"img\";s:32:\"blooming-funeral-text/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:2:\"12\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:425;a:25:{s:2:\"id\";s:3:\"461\";s:5:\"title\";s:16:\"Blooming Contact\";s:5:\"alias\";s:16:\"blooming-contact\";s:3:\"zip\";s:26:\"packs/blooming-contact.zip\";s:3:\"uid\";s:32:\"54280182bca86443e2648b3146f41e47\";s:3:\"img\";s:27:\"blooming-contact/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/event-florist-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:2:\"13\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:426;a:22:{s:2:\"id\";s:3:\"462\";s:5:\"title\";s:13:\"Particle Hero\";s:5:\"alias\";s:13:\"particle-hero\";s:3:\"zip\";s:17:\"particle-hero.zip\";s:3:\"uid\";s:32:\"3f422f4807bf9ef4cb15dade515dad00\";s:3:\"img\";s:24:\"particle-hero/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide6\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:120:\"<span class=\"ttm_content\">A Hero header module using the Particle Effect Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:427;a:22:{s:2:\"id\";s:3:\"463\";s:5:\"title\";s:17:\"Bubble Morph Hero\";s:5:\"alias\";s:17:\"bubble-morph-hero\";s:3:\"zip\";s:21:\"bubble-morph-hero.zip\";s:3:\"uid\";s:32:\"b47e6bcc1ae80393ff3f7388ed3b9f8f\";s:3:\"img\";s:28:\"bubble-morph-hero/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide5\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:117:\"<span class=\"ttm_content\">A Hero header module using the Bubble Morph Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:428;a:22:{s:2:\"id\";s:3:\"464\";s:5:\"title\";s:13:\"Parallax Hero\";s:5:\"alias\";s:13:\"parallax-hero\";s:3:\"zip\";s:17:\"parallax-hero.zip\";s:3:\"uid\";s:32:\"290e86534326ee118e96ae7ce0538fa2\";s:3:\"img\";s:24:\"parallax-hero/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide4\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:117:\"<span class=\"ttm_content\">A parallax hero module with mouse move interaction.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:429;a:22:{s:2:\"id\";s:3:\"465\";s:5:\"title\";s:10:\"Video Hero\";s:5:\"alias\";s:10:\"video-hero\";s:3:\"zip\";s:14:\"video-hero.zip\";s:3:\"uid\";s:32:\"f9e280015d3408bb0482e13fe753da8f\";s:3:\"img\";s:21:\"video-hero/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:111:\"<span class=\"ttm_content\">A simple Hero header module with HTML5 video.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:430;a:22:{s:2:\"id\";s:3:\"466\";s:5:\"title\";s:14:\"Ken Burns Hero\";s:5:\"alias\";s:14:\"ken-burns-hero\";s:3:\"zip\";s:18:\"ken-burns-hero.zip\";s:3:\"uid\";s:32:\"d5f89e5f5b3991b995e2bfeb50cfe9f8\";s:3:\"img\";s:25:\"ken-burns-hero/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:142:\"<span class=\"ttm_content\">A simple image background hero header module with a subtle Ken Burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:431;a:22:{s:2:\"id\";s:3:\"467\";s:5:\"title\";s:21:\"Basic Hero Collection\";s:5:\"alias\";s:21:\"basic-hero-collection\";s:3:\"zip\";s:25:\"basic-hero-collection.zip\";s:3:\"uid\";s:32:\"ff625c65e8aab4689fa56d5652279d51\";s:3:\"img\";s:32:\"basic-hero-collection/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-hero-image-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A collection of WordPress Hero Headers with image, video, particles, parallax and more!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:348:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:432;a:22:{s:2:\"id\";s:3:\"468\";s:5:\"title\";s:19:\"Launching Very Soon\";s:5:\"alias\";s:19:\"launching-very-soon\";s:3:\"zip\";s:23:\"launching-very-soon.zip\";s:3:\"uid\";s:32:\"2da45cf2d9bec07e7183b3f7777986b9\";s:3:\"img\";s:30:\"launching-very-soon/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/launching-soon-countdown/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:166:\"<span class=\"ttm_content\">Rocket BOOST! A beautifully animated launching soon countdown module using our \"Coming Soon\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:433;a:22:{s:2:\"id\";s:3:\"469\";s:5:\"title\";s:18:\"Under Construction\";s:5:\"alias\";s:18:\"Under-Construction\";s:3:\"zip\";s:22:\"Under-Construction.zip\";s:3:\"uid\";s:32:\"4b12f9a82a5b48d45a707df93406eb5b\";s:3:\"img\";s:29:\"Under-Construction/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/under-construction/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You will love this animated under construction landing page using our \"Coming Soon\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:434;a:22:{s:2:\"id\";s:3:\"470\";s:5:\"title\";s:15:\"Particle Effect\";s:5:\"alias\";s:15:\"Particle-Effect\";s:3:\"zip\";s:19:\"Particle-Effect.zip\";s:3:\"uid\";s:32:\"66cf4e514e83a6984903694fd587edb6\";s:3:\"img\";s:26:\"Particle-Effect/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/snow-particle-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\"<span class=\"ttm_content\">Get into a winter mood with our Snow Particle Scene for Slider Revolution!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:435;a:22:{s:2:\"id\";s:3:\"471\";s:5:\"title\";s:17:\"Particle Effect 2\";s:5:\"alias\";s:17:\"Particle-Effect-2\";s:3:\"zip\";s:21:\"Particle-Effect-2.zip\";s:3:\"uid\";s:32:\"303337c29a97a816ccecca7e5f0b5e20\";s:3:\"img\";s:28:\"Particle-Effect-2/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/cyber-particle-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">Amaze your website visitors with the cyber particle effect for Slider Revolution!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:436;a:25:{s:2:\"id\";s:3:\"472\";s:5:\"title\";s:22:\"Stark Website Template\";s:5:\"alias\";s:22:\"stark-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:30:\"stark-website-template-package\";s:3:\"img\";s:43:\"packages/stark-website-template-package.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:437;a:25:{s:2:\"id\";s:3:\"473\";s:5:\"title\";s:10:\"Stark Menu\";s:5:\"alias\";s:10:\"stark-menu\";s:3:\"zip\";s:20:\"packs/stark-menu.zip\";s:3:\"uid\";s:32:\"bb31150df180e784d76a1f5ea306bf05\";s:3:\"img\";s:21:\"stark-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:87:\"offset=\"t:0px,0px,0px,0px;b:0px,0px,0px,0px;l:140px,70px,0px,0px;r:140px,70px,0px,0px;\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:438;a:25:{s:2:\"id\";s:3:\"474\";s:5:\"title\";s:12:\"Stark Header\";s:5:\"alias\";s:12:\"stark-header\";s:3:\"zip\";s:22:\"packs/stark-header.zip\";s:3:\"uid\";s:32:\"62bfca01bf6e33cfad81d8df06498299\";s:3:\"img\";s:23:\"stark-header/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:93:\"offset=\"t:40px,30px,20px,10px;b:0px,0px,0px,0px;l:40px,30px,20px,10px;r:40px,30px,20px,10px;\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:439;a:25:{s:2:\"id\";s:3:\"475\";s:5:\"title\";s:13:\"Stark Content\";s:5:\"alias\";s:13:\"stark-content\";s:3:\"zip\";s:23:\"packs/stark-content.zip\";s:3:\"uid\";s:32:\"4577ca760133eb5d894c46f212f6eefb\";s:3:\"img\";s:24:\"stark-content/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:110:\"offset=\"t:-50px,-30px,-30px,-20px;b:0px,0px,0px,0px;l:140px,70px,50px,30px;r:140px,70px,50px,30px;\" zindex=\"6\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:440;a:25:{s:2:\"id\";s:3:\"476\";s:5:\"title\";s:14:\"Stark Carousel\";s:5:\"alias\";s:14:\"stark-carousel\";s:3:\"zip\";s:24:\"packs/stark-carousel.zip\";s:3:\"uid\";s:32:\"de63336d333eeff10eccfd5d9741e6c9\";s:3:\"img\";s:25:\"stark-carousel/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:108:\"offset=\"t:-50px,-30px,-30px,-20px;b:0px,0px,0px,0px;l:40px,30px,20px,10px;r:40px,30px,20px,10px;\" zindex=\"1\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:441;a:25:{s:2:\"id\";s:3:\"477\";s:5:\"title\";s:15:\"Stark Portfolio\";s:5:\"alias\";s:15:\"stark-portfolio\";s:3:\"zip\";s:25:\"packs/stark-portfolio.zip\";s:3:\"uid\";s:32:\"99fcf3df65f8471fe30bec1bf0c2350d\";s:3:\"img\";s:26:\"stark-portfolio/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:110:\"offset=\"t:-50px,-30px,-30px,-20px;b:0px,0px,0px,0px;l:140px,70px,50px,30px;r:140px,70px,50px,30px;\" zindex=\"5\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:442;a:25:{s:2:\"id\";s:3:\"478\";s:5:\"title\";s:22:\"Stark Portfolio Detail\";s:5:\"alias\";s:22:\"stark-portfolio-detail\";s:3:\"zip\";s:32:\"packs/stark-portfolio-detail.zip\";s:3:\"uid\";s:32:\"7484fc54f81daec07c93e992216310ce\";s:3:\"img\";s:33:\"stark-portfolio-detail/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:443;a:25:{s:2:\"id\";s:3:\"479\";s:5:\"title\";s:13:\"Stark Contact\";s:5:\"alias\";s:13:\"stark-contact\";s:3:\"zip\";s:23:\"packs/stark-contact.zip\";s:3:\"uid\";s:32:\"8d704226b7093123a9d9faf424da6c35\";s:3:\"img\";s:24:\"stark-contact/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:108:\"offset=\"t:-50px,-30px,-30px,-20px;b:0px,0px,0px,0px;l:40px,30px,20px,10px;r:40px,30px,20px,10px;\" zindex=\"2\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:444;a:25:{s:2:\"id\";s:3:\"480\";s:5:\"title\";s:12:\"Stark Footer\";s:5:\"alias\";s:12:\"stark-footer\";s:3:\"zip\";s:22:\"packs/stark-footer.zip\";s:3:\"uid\";s:32:\"e7132dc158e7dcdb4ef5b3a1aa00208a\";s:3:\"img\";s:23:\"stark-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:114:\"offset=\"t:-50px,-30px,-30px,-20px;b:40px,30px,20px,20px;l:140px,70px,50px,30px;r:140px,70px,50px,30px;\" zindex=\"3\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:445;a:25:{s:2:\"id\";s:3:\"481\";s:5:\"title\";s:16:\"Stark Newsletter\";s:5:\"alias\";s:16:\"stark-newsletter\";s:3:\"zip\";s:26:\"packs/stark-newsletter.zip\";s:3:\"uid\";s:32:\"bb76ddd68dbe6bda5ece7e4227a51413\";s:3:\"img\";s:27:\"stark-newsletter/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/stark-agency-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:33:\"usage=\"modal\" modal=\"s:#contact;\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:446;a:22:{s:2:\"id\";s:3:\"482\";s:5:\"title\";s:15:\"Big Summer Sale\";s:5:\"alias\";s:15:\"big-summer-sale\";s:3:\"zip\";s:19:\"big-summer-sale.zip\";s:3:\"uid\";s:32:\"a6779fa7109763209d234f9cf2e766c6\";s:3:\"img\";s:26:\"big-summer-sale/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/big-summer-sale-shop-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">The Big Summer Sale Shop Slider is a beautiful eye catcher for your e-commerce website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:447;a:22:{s:2:\"id\";s:3:\"483\";s:5:\"title\";s:18:\"Traveller Carousel\";s:5:\"alias\";s:18:\"traveller-carousel\";s:3:\"zip\";s:22:\"traveller-carousel.zip\";s:3:\"uid\";s:32:\"185344ed6236bea2906a79035d1d5702\";s:3:\"img\";s:29:\"traveller-carousel/slide1.jpg\";s:7:\"preview\";s:55:\"https://revolution.themepunch.com/travel-blog-carousel/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">A travel blog carousel with interesting parallax and ken burns effects!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:263:\"<span class=\"ttm_content\">Note that the content visible on all slides can be edited on the \"global layers\" slide.<br/>Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:448;a:22:{s:2:\"id\";s:3:\"484\";s:5:\"title\";s:16:\"Project Carousel\";s:5:\"alias\";s:16:\"project-carousel\";s:3:\"zip\";s:20:\"project-carousel.zip\";s:3:\"uid\";s:32:\"49c85ad406da943bdd25f08fd6496748\";s:3:\"img\";s:27:\"project-carousel/slide1.jpg\";s:7:\"preview\";s:51:\"https://revolution.themepunch.com/project-carousel/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">A project carousel with images and texts that can be customized easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:449;a:22:{s:2:\"id\";s:3:\"485\";s:5:\"title\";s:13:\"News Carousel\";s:5:\"alias\";s:13:\"news-carousel\";s:3:\"zip\";s:17:\"news-carousel.zip\";s:3:\"uid\";s:32:\"76f5b939150092a30038f161084140ae\";s:3:\"img\";s:24:\"news-carousel/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/news-carousel/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A news carousel with images and texts that can be customized easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:450;a:25:{s:2:\"id\";s:3:\"486\";s:5:\"title\";s:29:\"Story Blocks Website Template\";s:5:\"alias\";s:29:\"story-blocks-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:37:\"story-blocks-website-template-package\";s:3:\"img\";s:50:\"packages/story-blocks-website-template-package.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:451;a:25:{s:2:\"id\";s:3:\"487\";s:5:\"title\";s:10:\"Story Menu\";s:5:\"alias\";s:10:\"story-menu\";s:3:\"zip\";s:20:\"packs/story-menu.zip\";s:3:\"uid\";s:32:\"1f2f7cd91480f15cff8e7100f788c650\";s:3:\"img\";s:21:\"story-menu/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:452;a:25:{s:2:\"id\";s:3:\"488\";s:5:\"title\";s:12:\"Story Header\";s:5:\"alias\";s:12:\"story-header\";s:3:\"zip\";s:22:\"packs/story-header.zip\";s:3:\"uid\";s:32:\"e1a5ad5018a24ccdc71c2863edfe775e\";s:3:\"img\";s:23:\"story-header/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:453;a:25:{s:2:\"id\";s:3:\"489\";s:5:\"title\";s:13:\"Story Block 1\";s:5:\"alias\";s:13:\"story-block-1\";s:3:\"zip\";s:23:\"packs/story-block-1.zip\";s:3:\"uid\";s:32:\"2a9fee97dcf477e36d048af8a902f47a\";s:3:\"img\";s:24:\"story-block-1/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:454;a:25:{s:2:\"id\";s:3:\"490\";s:5:\"title\";s:15:\"Story Content 1\";s:5:\"alias\";s:15:\"story-content-1\";s:3:\"zip\";s:25:\"packs/story-content-1.zip\";s:3:\"uid\";s:32:\"6773614bbce543b83a0d2b2ad8facc96\";s:3:\"img\";s:26:\"story-content-1/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:455;a:25:{s:2:\"id\";s:3:\"491\";s:5:\"title\";s:13:\"Story Block 2\";s:5:\"alias\";s:13:\"story-block-2\";s:3:\"zip\";s:23:\"packs/story-block-2.zip\";s:3:\"uid\";s:32:\"2e708e3cebab57ca20b228ffba426ce7\";s:3:\"img\";s:24:\"story-block-2/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:456;a:25:{s:2:\"id\";s:3:\"492\";s:5:\"title\";s:13:\"Story Block 3\";s:5:\"alias\";s:13:\"story-block-3\";s:3:\"zip\";s:23:\"packs/story-block-3.zip\";s:3:\"uid\";s:32:\"7156cf069f65644faf90122dab451231\";s:3:\"img\";s:24:\"story-block-3/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:457;a:25:{s:2:\"id\";s:3:\"493\";s:5:\"title\";s:15:\"Story Content 2\";s:5:\"alias\";s:15:\"story-content-2\";s:3:\"zip\";s:25:\"packs/story-content-2.zip\";s:3:\"uid\";s:32:\"1223cd77d1f36d69e69ce50223e16ea7\";s:3:\"img\";s:26:\"story-content-2/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:458;a:25:{s:2:\"id\";s:3:\"494\";s:5:\"title\";s:13:\"Story Block 4\";s:5:\"alias\";s:13:\"story-block-4\";s:3:\"zip\";s:23:\"packs/story-block-4.zip\";s:3:\"uid\";s:32:\"85ac48e8e8231d2c38206cba4e7ebb68\";s:3:\"img\";s:24:\"story-block-4/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:459;a:25:{s:2:\"id\";s:3:\"495\";s:5:\"title\";s:15:\"Story Content 3\";s:5:\"alias\";s:15:\"story-content-3\";s:3:\"zip\";s:25:\"packs/story-content-3.zip\";s:3:\"uid\";s:32:\"82cac52f3ba79c0559fe0ad0cdf9d3b2\";s:3:\"img\";s:26:\"story-content-3/slide1.jpg\";s:7:\"preview\";s:47:\"https://revolution.themepunch.com/story-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}}s:6:\"slides\";a:448:{s:16:\"classic-carousel\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"classic-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"classic-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"classic-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"classic-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"classic-carousel/slide5.jpg\";}}s:13:\"classicslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"classicslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"classicslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"classicslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"classicslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:24:\"classicslider/slide5.jpg\";}}s:11:\"contenttabs\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contenttabs/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contenttabs/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contenttabs/slide3.jpg\";}}s:13:\"facebook-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"facebook-feed/slide1.jpg\";}}s:7:\"fashion\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"fashion/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"fashion/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"fashion/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"fashion/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"fashion/slide5.jpg\";}}s:14:\"flickr-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"flickr-gallery/slide1.jpg\";}}s:3:\"gym\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"gym/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:14:\"gym/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:14:\"gym/slide3.jpg\";}}s:18:\"highlight-carousel\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-carousel/slide4.jpg\";}}s:18:\"highlight-showcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-showcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-showcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-showcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-showcase/slide4.jpg\";}}s:10:\"image-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"imagehero/slide1.jpg\";}}s:13:\"insta-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"insta-gallery/slide1.jpg\";}}s:19:\"levanorestaurantbar\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"levanorestaurantbar/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"levanorestaurantbar/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"levanorestaurantbar/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:30:\"levanorestaurantbar/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:30:\"levanorestaurantbar/slide5.jpg\";}}s:11:\"mainfeature\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"mainfeature/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"mainfeature/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"mainfeature/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"mainfeature/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"mainfeature/slide7.jpg\";}}s:17:\"media-gallery-two\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"media-gallery-two/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"media-gallery-two/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"media-gallery-two/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"media-gallery-two/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"media-gallery-two/slide6.jpg\";}}s:23:\"media-carousel-autoplay\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide6.jpg\";}}s:21:\"news-background-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"news-bg-video/slide1.jpg\";}}s:12:\"news-gallery\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"news-gallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"news-gallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"news-gallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"news-gallery/slide4.jpg\";}}s:23:\"news-gallery-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"news-gallery-post-based/slide1.jpg\";}}s:9:\"news-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"news-hero/slide1.jpg\";}}s:10:\"news-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"news-video/slide1.jpg\";}}s:15:\"newsletter-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"newsletter-hero/slide1.jpg\";}}s:10:\"notgeneric\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"notgeneric/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"notgeneric/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"notgeneric/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"notgeneric/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"notgeneric/slide5.jpg\";}}s:11:\"photography\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"photography/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"photography/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"photography/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"photography/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:22:\"photography/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:22:\"photography/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"photography/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:22:\"photography/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:22:\"photography/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:23:\"photography/slide10.jpg\";}}s:20:\"photography-carousel\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"photography-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"photography-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"photography-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"photography-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:31:\"photography-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:31:\"photography-carousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:31:\"photography-carousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:31:\"photography-carousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:31:\"photography-carousel/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:32:\"photography-carousel/slide10.jpg\";}}s:16:\"search-form-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"search-form-hero/slide1.jpg\";}}s:16:\"showcasecarousel\";a:9:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"showcasecarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"showcasecarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"showcasecarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"showcasecarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"showcasecarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:27:\"showcasecarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:27:\"showcasecarousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:27:\"showcasecarousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:27:\"showcasecarousel/slide9.jpg\";}}s:11:\"sports-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"sportshero/slide1.jpg\";}}s:12:\"twitter-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"twitter-feed/slide1.jpg\";}}s:13:\"vimeo-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"vimeo-gallery/slide1.jpg\";}}s:9:\"vimeohero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"vimeohero/slide1.jpg\";}}s:16:\"web-product-dark\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"web-product-dark/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"web-product-dark/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"web-product-dark/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"web-product-dark/slide4.jpg\";}}s:21:\"web-product-dark-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"web-product-dark-hero/slide1.jpg\";}}s:22:\"web-product-light-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"web-product-light-hero/slide1.jpg\";}}s:15:\"webproductlight\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"webproductlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"webproductlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"webproductlight/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"webproductlight/slide4.jpg\";}}s:15:\"youtube-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"youtube-gallery/slide1.jpg\";}}s:11:\"youtubehero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"youtubehero/slide1.jpg\";}}s:13:\"scroll-effect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"scrolleffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"scrolleffect/slide3.jpg\";}}s:12:\"content-zoom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contentzoom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contentzoom/slide3.jpg\";}}s:13:\"food-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"foodcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"foodcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"foodcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"foodcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"foodcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"foodcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"foodcarousel/slide7.jpg\";}}s:14:\"rotating-words\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";}}s:22:\"travel-static-captions\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"travel-static-captions/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"travel-static-captions/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:33:\"travel-static-captions/slide4.jpg\";}}s:7:\"concept\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"concept/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"concept/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"concept/slide3.jpg\";}}s:17:\"fullscreen-button\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"fullscreen-button/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"fullscreen-button/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"fullscreen-button/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"fullscreen-button/slide5.jpg\";}}s:15:\"creativefreedom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"creativefreedom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"creativefreedom/slide3.jpg\";}}s:13:\"parallaxscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";}}s:15:\"slidingoverlays\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"slidingoverlays/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"slidingoverlays/slide3.jpg\";}}s:25:\"web-product-light-hero-3d\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";}}s:6:\"woobig\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";}}s:16:\"woocommercesmall\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";}}s:10:\"finedining\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";}}s:12:\"agency-intro\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";}}s:7:\"ourteam\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"ourteam/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"ourteam/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"ourteam/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"ourteam/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"ourteam/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:18:\"ourteam/slide7.jpg\";}}s:17:\"our-team-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"ourteamcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"ourteamcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"ourteamcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"ourteamcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"ourteamcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:26:\"ourteamcarousel/slide7.jpg\";}}s:13:\"betteryoutube\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"betteryoutube/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"betteryoutube/slide3.jpg\";}}s:19:\"agencywebsiteheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"agencywebsiteheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"agencywebsiteheader/slide3.jpg\";}}s:10:\"comingsoon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"comingsoon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"comingsoon/slide3.jpg\";}}s:9:\"snowscene\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowscene/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowscene/slide3.jpg\";}}s:8:\"rockband\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";}}s:16:\"sleeklandingpage\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"sleeklandingpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"sleeklandingpage/slide3.jpg\";}}s:14:\"applandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";}}s:9:\"deskscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";}}s:15:\"cleannewsslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"cleannewsslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"cleannewsslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"cleannewsslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"cleannewsslider/slide5.jpg\";}}s:12:\"imagegallery\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"imagegallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"imagegallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"imagegallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"imagegallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"imagegallery/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"imagegallery/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:23:\"imagegallery/slide8.jpg\";}}s:19:\"standard-wp-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";}}s:21:\"clean-news-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";}}s:21:\"interactivewhiteboard\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"interactivewhiteboard/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"interactivewhiteboard/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"interactivewhiteboard/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:32:\"interactivewhiteboard/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:32:\"interactivewhiteboard/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:32:\"interactivewhiteboard/slide8.jpg\";}}s:10:\"innovation\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"innovation/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"innovation/slide3.jpg\";}}s:24:\"dark-fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";}}s:21:\"dark-fullsite-block-1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";}}s:27:\"dark-fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide2.jpg\";}}s:30:\"dark-fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide2.jpg\";}}s:30:\"dark-fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide5.jpg\";}}s:34:\"dark-fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";}}s:29:\"dark-fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";}}s:28:\"dark-fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";}}s:19:\"fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";}}s:15:\"fullsite-block1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";}}s:22:\"fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide2.jpg\";}}s:25:\"fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide2.jpg\";}}s:25:\"fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide5.jpg\";}}s:29:\"fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";}}s:24:\"fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";}}s:23:\"fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";}}s:11:\"techjournal\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"techjournal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"techjournal/slide3.jpg\";}}s:13:\"cardealership\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"cardealership/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"cardealership/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"cardealership/slide4.jpg\";}}s:14:\"fullscreenmenu\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fullscreenmenu/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fullscreenmenu/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"fullscreenmenu/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"fullscreenmenu/slide5.jpg\";}}s:17:\"creativefrontpage\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"creativefrontpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"creativefrontpage/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"creativefrontpage/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"creativefrontpage/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"creativefrontpage/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:28:\"creativefrontpage/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:28:\"creativefrontpage/slide8.jpg\";}}s:19:\"websitebuilder-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";}}s:19:\"websitebuilder-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";}}s:22:\"websitebuilder-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";}}s:23:\"websitebuilder-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";}}s:23:\"websitebuilder-discover\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"websitebuilder-discover/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"websitebuilder-discover/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"websitebuilder-discover/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"websitebuilder-discover/slide5.jpg\";}}s:21:\"websitebuilder-slider\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"websitebuilder-slider/slide2.jpg\";}}s:27:\"websitebuilder-calltoaction\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";}}s:21:\"websitebuilder-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";}}s:13:\"focusparallax\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"focusparallax/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"focusparallax/slide3.jpg\";}}s:7:\"duotone\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"duotone/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"duotone/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"duotone/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"duotone/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"duotone/slide6.jpg\";}}s:6:\"r_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";}}s:5:\"rhero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";}}s:7:\"r_about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";}}s:10:\"r_products\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"r_products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"r_products/slide3.jpg\";}}s:6:\"r_info\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";}}s:17:\"inspirationheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";}}s:13:\"magazineposts\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"magazineposts/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"magazineposts/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"magazineposts/slide4.jpg\";}}s:17:\"explorationheader\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"explorationheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"explorationheader/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"explorationheader/slide4.jpg\";}}s:16:\"typewritereffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"typewritereffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"typewritereffect/slide3.jpg\";}}s:15:\"blendmodeheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";}}s:17:\"themeplicity_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";}}s:19:\"themeplicity_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";}}s:18:\"themeplicity_offer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";}}s:21:\"themeplicity_whatwedo\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";}}s:21:\"themeplicity_projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"themeplicity_projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"themeplicity_projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"themeplicity_projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:32:\"themeplicity_projects/slide5.jpg\";s:3:\"img\";s:7:\"Slide 5\";}}s:23:\"themeplicity_whatsgreat\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";}}s:19:\"themeplicity_tables\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";}}s:24:\"themeplicity_contactform\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";}}s:19:\"themeplicity_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";}}s:17:\"NiceAndClean_Menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";}}s:19:\"NiceAndClean_Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";}}s:21:\"NiceAndClean_Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";}}s:18:\"NiceAndClean_About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";}}s:18:\"niceandclean_video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";}}s:23:\"niceandclean_highlights\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";}}s:21:\"NiceAndClean_Projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide5.jpg\";}}s:23:\"niceandclean_textblocks\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";}}s:20:\"niceandclean_callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";}}s:19:\"niceandclean_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";}}s:3:\"80s\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"80s/slide1.jpg\";}}s:10:\"blurslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"blurslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"blurslider/slide3.jpg\";}}s:15:\"ComingSoonAddon\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";}}s:9:\"snowaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowaddon/slide3.jpg\";}}s:19:\"particle-effect-one\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"particle-effect-one/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"particle-effect-one/slide3.jpg\";}}s:19:\"particle-effect-two\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";}}s:21:\"particle-effect-three\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";}}s:15:\"portfolioviewer\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"portfolioviewer/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"portfolioviewer/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"portfolioviewer/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"portfolioviewer/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"portfolioviewer/slide6.jpg\";}}s:11:\"appshowcase\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";}}s:13:\"gravitydesign\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";}}s:12:\"404errorpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";}}s:15:\"carouselgallery\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"carouselgallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"carouselgallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"carouselgallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"carouselgallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"carouselgallery/slide6.jpg\";}}s:9:\"filmstrip\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"filmstrip/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"filmstrip/slide3.jpg\";}}s:10:\"spaceopera\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"spaceopera/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"spaceopera/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"spaceopera/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"spaceopera/slide5.jpg\";}}s:12:\"websiteintro\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"websiteintro/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"websiteintro/slide3.jpg\";}}s:12:\"maskshowcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"maskshowcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"maskshowcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"maskshowcase/slide4.jpg\";}}s:18:\"parallaxzoomslices\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"parallaxzoomslices/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"parallaxzoomslices/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"parallaxzoomslices/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:29:\"parallaxzoomslices/slide5.jpg\";}}s:20:\"doubleexposureeffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"doubleexposureeffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"doubleexposureeffect/slide3.jpg\";}}s:22:\"mountainparallaxheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";}}s:12:\"goodnewsmenu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";}}s:14:\"goodnewsheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"goodnewsheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"goodnewsheader/slide3.jpg\";}}s:16:\"goodnewswhatshot\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";}}s:16:\"goodnewsfeatured\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";}}s:17:\"goodnewsspotlight\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"goodnewsspotlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"goodnewsspotlight/slide3.jpg\";}}s:16:\"goodnewscarousel\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"goodnewscarousel/slide2.jpg\";}}s:15:\"goodnewscallout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";}}s:14:\"goodnewsfooter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";}}s:16:\"goodnewsmenuback\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";}}s:18:\"goodnewsblogheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";}}s:19:\"goodnewsblogcontent\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";}}s:20:\"goodnewstestimonials\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"goodnewstestimonials/slide2.jpg\";}}s:18:\"goodnewsblogfooter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";}}s:17:\"beforeafterslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"beforeafterslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"beforeafterslider/slide3.jpg\";}}s:15:\"productshowcase\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"productshowcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"productshowcase/slide3.jpg\";}}s:22:\"overexposuretransition\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"overexposuretransition/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"overexposuretransition/slide3.jpg\";}}s:14:\"parallaxscroll\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";}}s:11:\"techco-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";}}s:13:\"techco-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";}}s:12:\"techco-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";}}s:15:\"techco-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";}}s:12:\"techco-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";}}s:13:\"techco-prices\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";}}s:19:\"techco-testimonials\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"techco-testimonials/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"techco-testimonials/slide3.jpg\";}}s:13:\"techco-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";}}s:7:\"weather\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"weather/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"weather/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"weather/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"weather/slide4.jpg\";}}s:11:\"360panorama\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"360panorama/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"360panorama/slide3.jpg\";}}s:14:\"duotone-add-on\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"duotone-add-on/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"duotone-add-on/slide3.jpg\";}}s:13:\"reveal-add-on\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"reveal-add-on/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"reveal-add-on/slide3.jpg\";}}s:16:\"band-tour-poster\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"smartcontent/band-tour-poster/slide1.png\";}}s:14:\"brewery-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide3.png\";}}s:9:\"burgerbar\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide3.png\";}}s:19:\"burger-bar-portrait\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide3.png\";}}s:8:\"car-rent\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"smartcontent/car-rent/slide1.png\";}}s:6:\"coffee\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"smartcontent/coffee/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"smartcontent/coffee/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"smartcontent/coffee/slide3.png\";}}s:14:\"holiday-advert\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/holiday-advert/slide1.png\";}}s:18:\"iphone-cases-light\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:42:\"smartcontent/iphone-cases-light/slide1.png\";}}s:7:\"medical\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"smartcontent/medical/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"smartcontent/medical/slide2.png\";}}s:13:\"mexican-grill\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide3.png\";}}s:20:\"mobile-retail-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide3.png\";}}s:14:\"money-exchange\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide3.png\";}}s:28:\"restaurant-menu-first-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:52:\"smartcontent/restaurant-menu-first-screen/slide1.png\";}}s:29:\"restaurant-menu-second-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:53:\"smartcontent/restaurant-menu-second-screen/slide1.png\";}}s:28:\"restaurant-menu-third-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:52:\"smartcontent/restaurant-menu-third-screen/slide1.png\";}}s:11:\"shoes-store\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide3.png\";}}s:20:\"supermarket-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide3.png\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide4.png\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide5.png\";}}s:16:\"travel-insurance\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"smartcontent/travel-insurance/slide1.png\";}}s:12:\"cryptoslider\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"cryptoslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"cryptoslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"cryptoslider/slide4.jpg\";}}s:16:\"immersion_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";}}s:19:\"immersion-mountains\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";}}s:17:\"immersion-product\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";}}s:16:\"immersion-design\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";}}s:21:\"immersion-photography\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";}}s:14:\"immersion-grid\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";}}s:11:\"funkyslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"funkyslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"funkyslider/slide3.jpg\";}}s:14:\"clearview_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";}}s:16:\"clearview_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";}}s:17:\"clearview_mission\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";}}s:17:\"clear-view-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"clear-view-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"clear-view-slider/slide3.jpg\";}}s:15:\"clear-view-news\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";}}s:18:\"clear-view-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";}}s:18:\"clear-view-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";}}s:22:\"clear-view-single-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";}}s:24:\"clear-view-single-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";}}s:23:\"clear-view-single-media\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";}}s:22:\"clear-view-single-more\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";}}s:25:\"clear-view-single-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";}}s:16:\"cleanlandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";}}s:8:\"clearcut\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:19:\"clearcut/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:19:\"clearcut/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:19:\"clearcut/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:19:\"clearcut/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:19:\"clearcut/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:19:\"clearcut/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:19:\"clearcut/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:19:\"clearcut/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:20:\"clearcut/slide10.jpg\";}}s:17:\"wonderstruck_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";}}s:19:\"wonderstruck_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";}}s:18:\"wonderstruck_about\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"wonderstruck_about/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"wonderstruck_about/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"wonderstruck_about/slide4.jpg\";}}s:18:\"wonderstruck-works\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";}}s:20:\"wonderstruck-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";}}s:11:\"bubblemorph\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"bubblemorph/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"bubblemorph/slide3.jpg\";}}s:15:\"distortionaddon\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"distortionaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"distortionaddon/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"distortionaddon/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"distortionaddon/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"distortionaddon/slide6.jpg\";}}s:9:\"clubflyer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";}}s:15:\"paintbrushaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"paintbrushaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"paintbrushaddon/slide3.jpg\";}}s:15:\"parallax_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";}}s:16:\"parallax_content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";}}s:15:\"parallax_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";}}s:12:\"le-chef-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";}}s:14:\"le-chef-header\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"le-chef-header/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"le-chef-header/slide3.jpg\";}}s:18:\"le-chef-philosophy\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";}}s:12:\"le-chef-food\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";}}s:16:\"le-chef-la-carte\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";}}s:14:\"le-chef-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";}}s:20:\"news-magazine-slider\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"news-magazine-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"news-magazine-slider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"news-magazine-slider/slide4.jpg\";}}s:18:\"real-estate-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"real-estate-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"real-estate-slider/slide3.jpg\";}}s:14:\"fashion-header\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fashion-header/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fashion-header/slide3.jpg\";}}s:13:\"seasonaloffer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"seasonaloffer/slide1.jpg\";}}s:18:\"barber-shop-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"barber-shop-header/slide1.jpg\";}}s:23:\"barber-shop-mobile-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"barber-shop-mobile-menu/slide1.jpg\";}}s:24:\"barber-shop-first-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"barber-shop-first-screen/slide1.jpg\";}}s:17:\"barber-shop-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"barber-shop-about/slide1.jpg\";}}s:20:\"barber-shop-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"barber-shop-services/slide1.jpg\";}}s:19:\"barber-shop-barbers\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"barber-shop-barbers/slide1.jpg\";}}s:20:\"barber-shop-contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"barber-shop-contacts/slide1.jpg\";}}s:18:\"barber-shop-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"barber-shop-footer/slide1.jpg\";}}s:21:\"fitness-club-template\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"fitness-club-template/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"fitness-club-template/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"fitness-club-template/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"fitness-club-template/slide4.jpg\";}}s:13:\"soccer-school\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"soccer-school/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"soccer-school/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"soccer-school/slide3.jpg\";}}s:19:\"music-band-template\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"music-band-template/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"music-band-template/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"music-band-template/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:30:\"music-band-template/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:30:\"music-band-template/slide5.jpg\";}}s:15:\"restaurant-menu\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"restaurant-menu/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"restaurant-menu/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"restaurant-menu/slide3.jpg\";}}s:16:\"cinematic-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"cinematic-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"cinematic-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"cinematic-slider/slide3.jpg\";}}s:17:\"3d-parallax-cubes\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide3.jpg\";}}s:13:\"medicare-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"medicare-menu/slide1.jpg\";}}s:15:\"medicare-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"medicare-header/slide1.jpg\";}}s:14:\"medicare-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"medicare-about/slide1.jpg\";}}s:18:\"medicare-highlight\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"medicare-highlight/slide1.jpg\";}}s:17:\"medicare-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"medicare-services/slide1.jpg\";}}s:16:\"medicare-doctors\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"medicare-doctors/slide1.jpg\";}}s:17:\"medicare-research\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"medicare-research/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"medicare-research/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"medicare-research/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"medicare-research/slide4.jpg\";}}s:18:\"medicare-whychoose\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"medicare-whychoose/slide1.jpg\";}}s:16:\"medicare-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"medicare-contact/slide1.jpg\";}}s:15:\"medicare-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"medicare-footer/slide1.jpg\";}}s:11:\"coffee-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"coffee-menu/slide1.jpg\";}}s:13:\"coffee-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"coffee-header/slide1.jpg\";}}s:17:\"coffee-philosophy\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"coffee-philosophy/slide1.jpg\";}}s:12:\"coffee-carte\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"coffee-carte/slide1.jpg\";}}s:13:\"coffee-teaser\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"coffee-teaser/slide1.jpg\";}}s:13:\"coffee-findus\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"coffee-findus/slide1.jpg\";}}s:13:\"coffee-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"coffee-footer/slide1.jpg\";}}s:17:\"minimal-portfolio\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"minimal-portfolio/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"minimal-portfolio/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"minimal-portfolio/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"minimal-portfolio/slide4.jpg\";}}s:23:\"minimal-portfolio-modal\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide7.jpg\";}}s:11:\"angled-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"angled-menu/slide1.jpg\";}}s:13:\"angled-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"angled-header/slide1.jpg\";}}s:11:\"angled-news\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"angled-news/slide1.jpg\";}}s:15:\"angled-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"angled-services/slide1.jpg\";}}s:14:\"angled-success\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"angled-success/slide1.jpg\";}}s:13:\"angled-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"angled-footer/slide1.jpg\";}}s:20:\"angled-content-modal\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"angled-content-modal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"angled-content-modal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"angled-content-modal/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"angled-content-modal/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:31:\"angled-content-modal/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:31:\"angled-content-modal/slide6.jpg\";}}s:13:\"big-bold-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"big-bold-menu/slide1.jpg\";}}s:15:\"big-bold-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"big-bold-header/slide1.jpg\";}}s:16:\"big-bold-content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"big-bold-content/slide1.jpg\";}}s:13:\"big-bold-blog\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"big-bold-blog/slide1.jpg\";}}s:18:\"big-bold-highlight\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"big-bold-highlight/slide1.jpg\";}}s:15:\"big-bold-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"big-bold-footer/slide1.jpg\";}}s:7:\"Retouch\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"Retouch/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"Retouch/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"Retouch/slide3.jpg\";}}s:11:\"tech-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"tech-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"tech-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"tech-slider/slide3.jpg\";}}s:11:\"peak-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"peak-header/slide1.jpg\";}}s:10:\"peak-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"peak-about/slide1.jpg\";}}s:14:\"peak-portfolio\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"peak-portfolio/slide1.jpg\";}}s:11:\"peak-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"peak-footer/slide1.jpg\";}}s:17:\"portfolio-welcome\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"portfolio-welcome/slide1.jpg\";}}s:15:\"portfolio-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"portfolio-about/slide1.jpg\";}}s:21:\"portfolio-works-title\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"portfolio-works-title/slide1.jpg\";}}s:23:\"portfolio-works-content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"portfolio-works-content/slide1.jpg\";}}s:18:\"portfolio-contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"portfolio-contacts/slide1.jpg\";}}s:18:\"App-Studio-Welcome\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"App-Studio-Welcome/slide1.jpg\";}}s:19:\"App-Studio-Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"App-Studio-Services/slide1.jpg\";}}s:16:\"App-Studio-About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"App-Studio-About/slide1.jpg\";}}s:19:\"App-Studio-Contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"App-Studio-Contacts/slide1.jpg\";}}s:14:\"cube-animation\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"cube-animation/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"cube-animation/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"cube-animation/slide3.jpg\";}}s:10:\"basic-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"basic-menu/slide1.jpg\";}}s:12:\"basic-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"basic-header/slide1.jpg\";}}s:13:\"basic-content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"basic-content/slide1.jpg\";}}s:14:\"basic-carousel\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"basic-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"basic-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"basic-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"basic-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"basic-carousel/slide5.jpg\";}}s:13:\"basic-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"basic-callout/slide1.jpg\";}}s:10:\"basic-grid\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"basic-grid/slide1.jpg\";}}s:17:\"basic-video-block\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"basic-video-block/slide1.jpg\";}}s:12:\"basic-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"basic-footer/slide1.jpg\";}}s:14:\"basic-lightbox\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"basic-lightbox/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"basic-lightbox/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"basic-lightbox/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"basic-lightbox/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"basic-lightbox/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:25:\"basic-lightbox/slide6.jpg\";}}s:13:\"nature-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"nature-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"nature-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"nature-slider/slide3.jpg\";}}s:11:\"art-gallery\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"art-gallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"art-gallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"art-gallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"art-gallery/slide4.jpg\";}}s:19:\"Construction-Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"Construction-Header/slide1.jpg\";}}s:17:\"Construction-Home\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"Construction-Home/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"Construction-Home/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"Construction-Home/slide3.jpg\";}}s:21:\"Construction-Projects\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"Construction-Projects/slide1.jpg\";}}s:20:\"Construction-History\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"Construction-History/slide1.jpg\";}}s:21:\"Construction-Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"Construction-Services/slide1.jpg\";}}s:21:\"Construction-Contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"Construction-Contacts/slide1.jpg\";}}s:21:\"404-Error-Space-Theme\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"404-Error-Space-Theme/slide1.jpg\";}}s:17:\"landing-page-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"landing-page-hero/slide1.jpg\";}}s:21:\"landing-page-features\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"landing-page-features/slide1.jpg\";}}s:20:\"landing-page-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"landing-page-callout/slide1.jpg\";}}s:20:\"landing-page-content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"landing-page-content/slide1.jpg\";}}s:25:\"landing-page-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"landing-page-testimonials/slide1.jpg\";}}s:27:\"landing-page-call-to-action\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"landing-page-call-to-action/slide1.jpg\";}}s:17:\"landing-page-help\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"landing-page-help/slide1.jpg\";}}s:19:\"landing-page-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"landing-page-footer/slide1.jpg\";}}s:24:\"landing-page-price-modal\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"landing-page-price-modal/slide1.jpg\";}}s:18:\"energy-drinks-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"energy-drinks-hero/slide1.jpg\";}}s:19:\"energy-drinks-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"energy-drinks-about/slide1.jpg\";}}s:21:\"energy-drinks-product\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"energy-drinks-product/slide1.jpg\";}}s:23:\"energy-drinks-product-2\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"energy-drinks-product-2/slide1.jpg\";}}s:23:\"energy-drinks-product-3\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"energy-drinks-product-3/slide1.jpg\";}}s:19:\"energy-drinks-order\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"energy-drinks-order/slide1.jpg\";}}s:20:\"energy-drinks-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"energy-drinks-footer/slide1.jpg\";}}s:19:\"energy-drinks-modal\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"energy-drinks-modal/slide1.jpg\";}}s:16:\"Corporate-Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"Corporate-Header/slide1.jpg\";}}s:24:\"Corporate-Welcome-Screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"Corporate-Welcome-Screen/slide1.jpg\";}}s:15:\"Corporate-About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"Corporate-About/slide1.jpg\";}}s:19:\"Corporate-Portfolio\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"Corporate-Portfolio/slide1.jpg\";}}s:15:\"Corporate-Chart\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"Corporate-Chart/slide1.jpg\";}}s:14:\"Corporate-News\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"Corporate-News/slide1.jpg\";}}s:16:\"Corporate-Hiring\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"Corporate-News/slide1.jpg\";}}s:22:\"Corporate-Testimonials\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"Corporate-Testimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"Corporate-Testimonials/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"Corporate-Testimonials/slide3.jpg\";}}s:15:\"Corporate-Store\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"Corporate-Store/slide1.jpg\";}}s:17:\"Corporate-Support\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"Corporate-Support/slide1.jpg\";}}s:14:\"Corporate-Team\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"Corporate-Team/slide1.jpg\";}}s:33:\"Corporate-Selected-Projects-Title\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"Corporate-Selected-Projects-Title/slide1.jpg\";}}s:27:\"Corporate-Selected-Projects\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide7.jpg\";}}s:17:\"Corporate-Clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"Corporate-Clients/slide1.jpg\";}}s:20:\"Corporate-Text-Block\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"Corporate-Text-Block/slide1.jpg\";}}s:20:\"Corporate-Mobile-App\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"Corporate-Mobile-App/slide1.jpg\";}}s:18:\"Corporate-Contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"Corporate-Contacts/slide1.jpg\";}}s:16:\"Corporate-Footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"Corporate-Footer/slide1.jpg\";}}s:23:\"Corporate-Scroll-To-Top\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"Corporate-Scroll-To-Top/slide1.jpg\";}}s:14:\"geometric-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"geometric-menu/slide1.jpg\";}}s:14:\"geometric-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"geometric-hero/slide1.jpg\";}}s:14:\"geometric-grid\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"geometric-grid/slide1.jpg\";}}s:15:\"geometric-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"geometric-about/slide1.jpg\";}}s:15:\"geometric-texts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"geometric-texts/slide1.jpg\";}}s:18:\"geometric-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"geometric-services/slide1.jpg\";}}s:17:\"geometric-texts-2\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"geometric-texts-2/slide1.jpg\";}}s:22:\"geometric-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"geometric-testimonials/slide1.jpg\";}}s:16:\"geometric-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"geometric-footer/slide1.jpg\";}}s:18:\"geometric-lightbox\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"geometric-lightbox/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"geometric-lightbox/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"geometric-lightbox/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"geometric-lightbox/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:29:\"geometric-lightbox/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:29:\"geometric-lightbox/slide6.jpg\";}}s:11:\"brutal-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"brutal-menu/slide1.jpg\";}}s:11:\"brutal-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"brutal-hero/slide1.jpg\";}}s:12:\"brutal-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"brutal-about/slide1.jpg\";}}s:16:\"brutal-highlight\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"brutal-highlight/slide1.jpg\";}}s:15:\"brutal-projects\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"brutal-projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"brutal-projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"brutal-projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"brutal-projects/slide4.jpg\";}}s:15:\"brutal-services\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"brutal-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"brutal-services/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"brutal-services/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"brutal-services/slide4.jpg\";}}s:14:\"brutal-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"brutal-callout/slide1.jpg\";}}s:13:\"brutal-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"brutal-footer/slide1.jpg\";}}s:13:\"Church-Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"Church-Header/slide1.jpg\";}}s:22:\"Church-Upcoming-Events\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"Church-Upcoming-Events/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"Church-Upcoming-Events/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"Church-Upcoming-Events/slide3.jpg\";}}s:12:\"Church-About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"Church-About/slide1.jpg\";}}s:14:\"Church-Pastors\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"Church-Pastors/slide1.jpg\";}}s:20:\"Church-Photo-Gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"Church-Photo-Gallery/slide1.jpg\";}}s:16:\"Church-Community\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"Church-Community/slide1.jpg\";}}s:13:\"Church-Sermon\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"Church-Sermon/slide1.jpg\";}}s:15:\"Church-Contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"Church-Contacts/slide1.jpg\";}}s:13:\"Church-Footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"Church-Footer/slide1.jpg\";}}s:19:\"Church-Light-Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"Church-Light-Header/slide1.jpg\";}}s:28:\"Church-Light-Upcoming-Events\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:39:\"Church-Light-Upcoming-Events/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:39:\"Church-Light-Upcoming-Events/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:39:\"Church-Light-Upcoming-Events/slide3.jpg\";}}s:18:\"Church-Light-About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"Church-Light-About/slide1.jpg\";}}s:20:\"Church-Light-Pastors\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"Church-Light-Pastors/slide1.jpg\";}}s:26:\"Church-Light-Photo-Gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:37:\"Church-Light-Photo-Gallery/slide1.jpg\";}}s:22:\"Church-Light-Community\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"Church-Light-Community/slide1.jpg\";}}s:19:\"Church-Light-Sermon\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"Church-Light-Sermon/slide1.jpg\";}}s:21:\"Church-Light-Contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"Church-Light-Contacts/slide1.jpg\";}}s:19:\"Church-Light-Footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"Church-Light-Footer/slide1.jpg\";}}s:13:\"rockable-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"rockable-menu/slide1.jpg\";}}s:13:\"rockable-hero\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"rockable-hero/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"rockable-hero/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"rockable-hero/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"rockable-hero/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:24:\"rockable-hero/slide5.jpg\";}}s:15:\"rockable-lineup\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"rockable-lineup/slide1.jpg\";}}s:17:\"rockable-lineup-2\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"rockable-lineup-2/slide1.jpg\";}}s:22:\"rockable-gallery-title\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"rockable-gallery-title/slide1.jpg\";}}s:16:\"rockable-gallery\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"rockable-gallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"rockable-gallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"rockable-gallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"rockable-gallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"rockable-gallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:27:\"rockable-gallery/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:27:\"rockable-gallery/slide7.jpg\";}}s:17:\"rockable-sponsors\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"rockable-sponsors/slide1.jpg\";}}s:15:\"rockable-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"rockable-footer/slide1.jpg\";}}s:21:\"rockable-detail-modal\";a:18:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:10;a:2:{s:5:\"title\";s:8:\"Slide 11\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:11;a:2:{s:5:\"title\";s:8:\"Slide 12\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:12;a:2:{s:5:\"title\";s:8:\"Slide 13\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:13;a:2:{s:5:\"title\";s:8:\"Slide 14\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:14;a:2:{s:5:\"title\";s:8:\"Slide 15\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:15;a:2:{s:5:\"title\";s:8:\"Slide 16\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:16;a:2:{s:5:\"title\";s:8:\"Slide 17\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}i:17;a:2:{s:5:\"title\";s:8:\"Slide 18\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";}}s:23:\"rockable-detail-modal-2\";a:18:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:10;a:2:{s:5:\"title\";s:8:\"Slide 11\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:11;a:2:{s:5:\"title\";s:8:\"Slide 12\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:12;a:2:{s:5:\"title\";s:8:\"Slide 13\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:13;a:2:{s:5:\"title\";s:8:\"Slide 14\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:14;a:2:{s:5:\"title\";s:8:\"Slide 15\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:15;a:2:{s:5:\"title\";s:8:\"Slide 16\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:16;a:2:{s:5:\"title\";s:8:\"Slide 17\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}i:17;a:2:{s:5:\"title\";s:8:\"Slide 18\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";}}s:27:\"Real-Estate-Showcase-Slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"Real-Estate-Showcase-Slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"Real-Estate-Showcase-Slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"Real-Estate-Showcase-Slider/slide3.jpg\";}}s:16:\"isometric-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"isometric-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"isometric-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"isometric-slider/slide3.jpg\";}}s:17:\"E-Commerce-Slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"Shoes-Store-Slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"Shoes-Store-Slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"Shoes-Store-Slider/slide3.jpg\";}}s:23:\"E-Commerce-Slider-Modal\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"Shoes-Store-Slider-Modal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:35:\"Shoes-Store-Slider-Modal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:35:\"Shoes-Store-Slider-Modal/slide3.jpg\";}}s:27:\"Woo-Commerce-Slider-Dynamic\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:37:\"Shoes-Store-Slider-Dynamic/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:37:\"Shoes-Store-Slider-Dynamic/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:37:\"Shoes-Store-Slider-Dynamic/slide3.jpg\";}}s:15:\"blooming-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"blooming-header/slide1.jpg\";}}s:14:\"blooming-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"blooming-about/slide1.jpg\";}}s:18:\"blooming-portfolio\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"blooming-portfolio/slide1.jpg\";}}s:22:\"blooming-wedding-title\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"blooming-wedding-title/slide1.jpg\";}}s:25:\"blooming-wedding-carousel\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"blooming-wedding-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"blooming-wedding-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:36:\"blooming-wedding-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:36:\"blooming-wedding-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:36:\"blooming-wedding-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:36:\"blooming-wedding-carousel/slide6.jpg\";}}s:21:\"blooming-wedding-text\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"blooming-wedding-text/slide1.jpg\";}}s:22:\"blooming-parties-title\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"blooming-parties-title/slide1.jpg\";}}s:25:\"blooming-parties-carousel\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"blooming-parties-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"blooming-parties-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:36:\"blooming-parties-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:36:\"blooming-parties-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:36:\"blooming-parties-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:36:\"blooming-parties-carousel/slide6.jpg\";}}s:21:\"blooming-parties-text\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"blooming-parties-text/slide1.jpg\";}}s:22:\"blooming-funeral-title\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"blooming-funeral-title/slide1.jpg\";}}s:23:\"blooming-funeral-slider\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"blooming-funeral-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"blooming-funeral-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"blooming-funeral-slider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"blooming-funeral-slider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"blooming-funeral-slider/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"blooming-funeral-slider/slide6.jpg\";}}s:21:\"blooming-funeral-text\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"blooming-funeral-text/slide1.jpg\";}}s:16:\"blooming-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"blooming-contact/slide1.jpg\";}}s:13:\"particle-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"particle-hero/slide1.jpg\";}}s:17:\"bubble-morph-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"bubble-morph-hero/slide1.jpg\";}}s:13:\"parallax-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"parallax-hero/slide1.jpg\";}}s:10:\"video-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"video-hero/slide1.jpg\";}}s:14:\"ken-burns-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"ken-burns-hero/slide1.jpg\";}}s:21:\"basic-hero-collection\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"basic-hero-collection/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"basic-hero-collection/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"basic-hero-collection/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"basic-hero-collection/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"basic-hero-collection/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:32:\"basic-hero-collection/slide6.jpg\";}}s:19:\"launching-very-soon\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"launching-very-soon/slide1.jpg\";}}s:18:\"Under-Construction\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"Under-Construction/slide1.jpg\";}}s:15:\"Particle-Effect\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"Particle-Effect/slide1.jpg\";}}s:17:\"Particle-Effect-2\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"Particle-Effect-2/slide1.jpg\";}}s:10:\"stark-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"stark-menu/slide1.jpg\";}}s:12:\"stark-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"stark-header/slide1.jpg\";}}s:13:\"stark-content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"stark-content/slide1.jpg\";}}s:14:\"stark-carousel\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"stark-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"stark-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"stark-carousel/slide3.jpg\";}}s:15:\"stark-portfolio\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"stark-portfolio/slide1.jpg\";}}s:22:\"stark-portfolio-detail\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"stark-portfolio-detail/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"stark-portfolio-detail/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"stark-portfolio-detail/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:33:\"stark-portfolio-detail/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:33:\"stark-portfolio-detail/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:33:\"stark-portfolio-detail/slide6.jpg\";}}s:13:\"stark-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"stark-contact/slide1.jpg\";}}s:12:\"stark-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"stark-footer/slide1.jpg\";}}s:16:\"stark-newsletter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"stark-newsletter/slide1.jpg\";}}s:15:\"big-summer-sale\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"big-summer-sale/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"big-summer-sale/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"big-summer-sale/slide3.jpg\";}}s:18:\"traveller-carousel\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"traveller-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"traveller-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"traveller-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"traveller-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:29:\"traveller-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:29:\"traveller-carousel/slide6.jpg\";}}s:16:\"project-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"project-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"project-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"project-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"project-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"project-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:27:\"project-carousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:27:\"project-carousel/slide7.jpg\";}}s:13:\"news-carousel\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"news-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"news-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"news-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"news-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:24:\"news-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:24:\"news-carousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:24:\"news-carousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:24:\"news-carousel/slide8.jpg\";}}s:10:\"story-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"story-menu/slide1.jpg\";}}s:12:\"story-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"story-header/slide1.jpg\";}}s:13:\"story-block-1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"story-block-1/slide1.jpg\";}}s:15:\"story-content-1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"story-content-1/slide1.jpg\";}}s:13:\"story-block-2\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"story-block-2/slide1.jpg\";}}s:13:\"story-block-3\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"story-block-3/slide1.jpg\";}}s:15:\"story-content-2\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"story-content-2/slide1.jpg\";}}s:13:\"story-block-4\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"story-block-4/slide1.jpg\";}}s:15:\"story-content-3\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"story-content-3/slide1.jpg\";}}}}", "no");
INSERT INTO `wp_options` VALUES("44927", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("44930", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("44932", "theme_mods_twentynineteen", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:6:\"menu-1\";i:34;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1571348363;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:18:{i:0;s:18:\"pyre_tabs-widget-2\";i:1;s:18:\"pyre_tabs-widget-3\";i:2;s:22:\"recent_works-widget-10\";i:3;s:22:\"recent_works-widget-11\";i:4;s:7:\"text-15\";i:5;s:21:\"recent_works-widget-6\";i:6;s:21:\"contact_info-widget-3\";i:7;s:7:\"text-14\";i:8;s:21:\"recent_works-widget-9\";i:9;s:21:\"contact_info-widget-2\";i:10;s:12:\"categories-3\";i:11;s:14:\"recent-posts-3\";i:12;s:6:\"text-3\";i:13;s:8:\"search-3\";i:14;s:22:\"recent_works-widget-12\";i:15;s:12:\"categories-4\";i:16;s:18:\"pyre_tabs-widget-5\";i:17;s:28:\"avada-vertical-menu-widget-2\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:18:\"pyre_tabs-widget-4\";i:2;s:14:\"recent-posts-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("44939", "woocommerce_single_image_width", "700", "yes");
INSERT INTO `wp_options` VALUES("44934", "fusion_registration_data", "a:1:{s:5:\"avada\";a:2:{s:5:\"token\";s:0:\"\";s:8:\"is_valid\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("44937", "_transient_timeout_avada_demos", "1571953165", "no");
INSERT INTO `wp_options` VALUES("45330", "_transient_timeout_fusion_dynamic_css_a98b374ad880446aaa2669df4486934e", "1571867533", "no");
INSERT INTO `wp_options` VALUES("44940", "woocommerce_thumbnail_image_width", "500", "yes");
INSERT INTO `wp_options` VALUES("44941", "woocommerce_thumbnail_cropping", "uncropped", "yes");
INSERT INTO `wp_options` VALUES("24767", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("24768", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("24769", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("24770", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("24771", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("24772", "woocommerce_shop_page_id", "4097", "yes");
INSERT INTO `wp_options` VALUES("24773", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `wp_options` VALUES("24774", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `wp_options` VALUES("24775", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `wp_options` VALUES("24776", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("24777", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("24778", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("24779", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("24780", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("24781", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("24782", "woocommerce_stock_email_recipient", "YourEmail@yahoo.com", "no");
INSERT INTO `wp_options` VALUES("24783", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("24784", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("24785", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("24786", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("24787", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("24788", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("24789", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("24790", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("24791", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("24792", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("24793", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("24794", "woocommerce_tax_classes", "Reduced rate\nZero rate", "yes");
INSERT INTO `wp_options` VALUES("24795", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("24796", "woocommerce_tax_display_cart", "excl", "no");
INSERT INTO `wp_options` VALUES("24797", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("24798", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("24799", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("24800", "woocommerce_shipping_cost_requires_address", "no", "no");
INSERT INTO `wp_options` VALUES("24801", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("24802", "woocommerce_shipping_debug_mode", "no", "no");
INSERT INTO `wp_options` VALUES("24803", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("24804", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("24805", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("24806", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("24807", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("24808", "woocommerce_cart_page_id", "12868", "yes");
INSERT INTO `wp_options` VALUES("24809", "woocommerce_checkout_page_id", "12869", "yes");
INSERT INTO `wp_options` VALUES("24810", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("24811", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("24812", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("24813", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("24814", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("24815", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("24816", "woocommerce_myaccount_page_id", "12870", "yes");
INSERT INTO `wp_options` VALUES("24817", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("24818", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_options` VALUES("24819", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_options` VALUES("24820", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("24821", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("24822", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("24823", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("24824", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("24825", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("24826", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("24827", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("24828", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("24829", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("24830", "woocommerce_email_from_name", "ProStyle Classic", "no");
INSERT INTO `wp_options` VALUES("24831", "woocommerce_email_from_address", "YourEmail@yahoo.com", "no");
INSERT INTO `wp_options` VALUES("24832", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("24833", "woocommerce_email_footer_text", "ProStyle Classic", "no");
INSERT INTO `wp_options` VALUES("24834", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("24835", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("24836", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("24837", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("24838", "woocommerce_api_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("24728", "revslider_servers", "a:7:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-b.tools\";i:3;s:16:\"themepunch.tools\";i:4;s:22:\"themepunch-ext-a.tools\";i:5;s:22:\"themepunch-ext-a.tools\";i:6;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("24729", "revslider_server_refresh", "1580840544", "yes");
INSERT INTO `wp_options` VALUES("24878", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("25059", "widget_bbp_search_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("45101", "woocommerce_version", "3.7.1", "yes");
INSERT INTO `wp_options` VALUES("24843", "woocommerce_db_version", "3.2.4", "yes");
INSERT INTO `wp_options` VALUES("140", "current_theme", "Avada By Pro Style Team", "yes");
INSERT INTO `wp_options` VALUES("141", "theme_mods_Avada-Child-Theme", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:9:\"404_pages\";i:33;s:15:\"main_navigation\";i:34;s:14:\"top_navigation\";i:36;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1502879327;s:4:\"data\";a:14:{s:19:\"wp_inactive_widgets\";a:10:{i:0;s:7:\"text-14\";i:1;s:21:\"contact_info-widget-4\";i:2;s:18:\"pyre_tabs-widget-7\";i:3;s:18:\"pyre_tabs-widget-8\";i:4;s:18:\"pyre_tabs-widget-9\";i:5;s:19:\"pyre_tabs-widget-10\";i:6;s:21:\"recent_works-widget-7\";i:7;s:21:\"recent_works-widget-8\";i:8;s:21:\"recent_works-widget-9\";i:9;s:21:\"social_links-widget-4\";}s:18:\"avada-blog-sidebar\";a:11:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";i:6;s:6:\"text-6\";i:7;s:21:\"recent_works-widget-4\";i:8;s:14:\"recent-posts-5\";i:9;s:6:\"text-7\";i:10;s:21:\"contact_info-widget-3\";}s:21:\"avada-footer-widget-1\";a:1:{i:0;s:6:\"text-3\";}s:21:\"avada-footer-widget-2\";a:1:{i:0;s:14:\"recent-posts-6\";}s:21:\"avada-footer-widget-3\";a:1:{i:0;s:12:\"categories-7\";}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:1:{i:0;s:7:\"text-11\";}s:35:\"avada-custom-sidebar-contactsidebar\";a:3:{i:0;s:21:\"contact_info-widget-2\";i:1;s:6:\"text-8\";i:2;s:21:\"social_links-widget-3\";}s:24:\"avada-custom-sidebar-faq\";a:1:{i:0;s:8:\"search-3\";}s:36:\"avada-custom-sidebar-homepagesidebar\";a:5:{i:0;s:8:\"search-4\";i:1;s:18:\"pyre_tabs-widget-4\";i:2;s:21:\"recent_works-widget-5\";i:3;s:14:\"recent-posts-3\";i:4;s:6:\"text-5\";}s:30:\"avada-custom-sidebar-portfolio\";a:2:{i:0;s:6:\"text-9\";i:1;s:6:\"text-4\";}s:30:\"avada-custom-sidebar-megamenu1\";a:1:{i:0;s:7:\"text-13\";}s:30:\"avada-custom-sidebar-megamenu2\";a:1:{i:0;s:7:\"text-12\";}s:18:\"orphaned_widgets_1\";a:1:{i:0;s:21:\"recent_works-widget-6\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("142", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("143", "avada_version", "6.1.1", "yes");
INSERT INTO `wp_options` VALUES("144", "widget_ad_125_125-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("145", "widget_contact_info-widget", "a:3:{i:2;a:17:{s:5:\"title\";s:23:\"اطلاعات تماس\";s:7:\"address\";s:79:\"تهران، خیابان ولیعصر، خیابان مینا، شماره 333\";s:5:\"phone\";s:13:\"021-7777-8888\";s:6:\"mobile\";s:11:\"09123334444\";s:3:\"fax\";s:13:\"021-7777-8888\";s:5:\"email\";s:23:\"info@classic.wpstyle.ir\";s:8:\"emailtxt\";s:0:\"\";s:3:\"web\";s:23:\"https://www.prostyle.ir\";s:6:\"webtxt\";s:15:\"www.prostyle.ir\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:3;a:17:{s:5:\"title\";s:23:\"اطلاعات تماس\";s:7:\"address\";s:79:\"تهران، خیابان ولیعصر، خیابان مینا، شماره 333\";s:5:\"phone\";s:13:\"021-7777-8888\";s:6:\"mobile\";s:11:\"09123334444\";s:3:\"fax\";s:13:\"021-7777-8888\";s:5:\"email\";s:23:\"info@classic.wpstyle.ir\";s:8:\"emailtxt\";s:0:\"\";s:3:\"web\";s:23:\"https://www.prostyle.ir\";s:6:\"webtxt\";s:15:\"www.prostyle.ir\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("146", "widget_pyre_tabs-widget", "a:5:{i:2;a:15:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:1:\"3\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:7:\"orderby\";s:27:\"بالاترین نظرات\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:3;a:15:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:1:\"3\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:7:\"orderby\";s:27:\"بالاترین نظرات\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:4;a:15:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:1:\"3\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:7:\"orderby\";s:10:\"view_count\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:5;a:15:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:1:\"3\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:7:\"orderby\";s:10:\"view_count\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("147", "widget_recent_works-widget", "a:6:{i:6;a:2:{s:5:\"title\";s:28:\"پروژه‌های اخیر\";s:6:\"number\";s:1:\"8\";}i:9;a:2:{s:5:\"title\";s:21:\"کارهای اخیر\";s:6:\"number\";s:1:\"8\";}i:10;a:10:{s:5:\"title\";s:21:\"کارهای اخیر\";s:6:\"number\";s:1:\"6\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:11;a:10:{s:5:\"title\";s:21:\"کارهای اخیر\";s:6:\"number\";s:1:\"6\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:12;a:10:{s:5:\"title\";s:21:\"کارهای اخیر\";s:6:\"number\";s:1:\"6\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("148", "widget_tweets-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("149", "widget_flickr-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("150", "widget_social_links-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("151", "widget_facebook-like-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("152", "widget_menu-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("417", "avada_disable_encoding", "1", "yes");
INSERT INTO `wp_options` VALUES("311", "fusion_dynamic_css_time", "1578809559", "yes");
INSERT INTO `wp_options` VALUES("188", "fusion_core_version", "4.1.1", "yes");
INSERT INTO `wp_options` VALUES("44935", "avada_page_options", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("204", "fusion_builder_version", "2.1.1", "yes");
INSERT INTO `wp_options` VALUES("221", "ls-plugin-version", "6.9.2", "yes");
INSERT INTO `wp_options` VALUES("222", "ls-db-version", "6.9.0", "yes");
INSERT INTO `wp_options` VALUES("223", "ls-installed", "1", "yes");
INSERT INTO `wp_options` VALUES("224", "ls-date-installed", "1497006508", "yes");
INSERT INTO `wp_options` VALUES("226", "fusion_supported_plugins_active", "a:3:{i:0;s:5:\"WPCF7\";i:1;s:17:\"LS_PLUGIN_VERSION\";i:2;s:14:\"RS_PLUGIN_PATH\";}", "yes");
INSERT INTO `wp_options` VALUES("236", "layerslider_update_info", "O:8:\"stdClass\":5:{s:5:\"basic\";O:8:\"stdClass\":10:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:27:\"LayerSlider/layerslider.php\";s:7:\"version\";s:6:\"6.10.1\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:5:\"5.3.2\";s:14:\"upgrade_notice\";s:142:\"This release further improves compatibility with WordPress 5.3 and is strongly recommended for everyone using the latest version of WordPress.\";s:11:\"new_version\";s:6:\"6.10.1\";}s:4:\"full\";O:8:\"stdClass\":20:{s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"homepage\";s:72:\"http://kreaturamedia.com/layerslider-responsive-wordpress-slider-plugin/\";s:5:\"p_url\";s:46:\"https://layerslider.kreaturamedia.com/pricing/\";s:7:\"version\";s:6:\"6.10.1\";s:12:\"last_updated\";s:10:\"2020-02-11\";s:8:\"requires\";s:3:\"3.5\";s:6:\"tested\";s:5:\"5.3.2\";s:6:\"rating\";s:2:\"95\";s:11:\"num_ratings\";i:3147;s:14:\"upgrade_notice\";a:3:{s:6:\"stable\";s:142:\"This release further improves compatibility with WordPress 5.3 and is strongly recommended for everyone using the latest version of WordPress.\";s:4:\"beta\";s:142:\"This release further improves compatibility with WordPress 5.3 and is strongly recommended for everyone using the latest version of WordPress.\";s:4:\"edge\";s:142:\"This release further improves compatibility with WordPress 5.3 and is strongly recommended for everyone using the latest version of WordPress.\";}s:6:\"author\";s:80:\"<a href=\"http://codecanyon.net/user/kreatura\" target=\"_blank\">Kreatura Media</a>\";s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:8:\"external\";b:1;s:9:\"file_name\";s:10:\"plugin.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:8:\"sections\";a:3:{s:9:\"changelog\";s:343:\"<p style=\"text-align: justify;\">\n	<a href=\"https://layerslider.kreaturamedia.com/release-log/\" target=\"_blank\">Click here to see the release log.</a> Don’t forget, the release log and all product-related news are also integrated right into LayerSlider. Look for the “LayerSlider News” section at the bottom of its main admin screen.\n</p>\";s:12:\"installation\";s:563:\"<p style=\"text-align: justify;\">\n	Updating the plugin won’t touch your sliders or settings. New versions always have backward compatibility. You don’t have to worry about losing your work. Not sure how to update? Check the <a href=\"https://layerslider.kreaturamedia.com/documentation/#updating\" target=\"_blank\">Updating</a> section of our online documentation.\n</p>\n\n<p style=\"text-align: justify;\">\n	If you’re experiencing unwanted changes, it is always a good idea to check your settings since there are probably new options to control those changes.\n</p>\";s:3:\"faq\";s:607:\"<p style=\"text-align: justify;\">\n	Please visit our <a href=\"https://layerslider.kreaturamedia.com/help/\" target=\"_blank\">Help</a> page, where you can find all sorts of useful assets like <a href=\"https://layerslider.kreaturamedia.com/faq/\" target=\"_blank\">FAQs</a>, <a href=\"https://layerslider.kreaturamedia.com/documentation/\" target=\"_blank\">online documentation</a>, <a href=\"https://layerslider.kreaturamedia.com/documentation/#troubleshooting\" target=\"_blank\">troubleshooting</a>, and <a href=\"https://layerslider.kreaturamedia.com/documentation/#support\" target=\"_blank\">support</a> information.\n</p>\";}s:4:\"slug\";s:11:\"LayerSlider\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";}s:15:\"_latest_version\";s:6:\"6.10.1\";s:14:\"_not_activated\";b:1;s:7:\"checked\";i:1581511922;}", "yes");
INSERT INTO `wp_options` VALUES("243", "revslider-update-check-short", "1581511934", "yes");
INSERT INTO `wp_options` VALUES("244", "revslider-templates-check", "1581511935", "yes");
INSERT I